/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.api.energy;

public enum CableTier {
    LV("lv", 32L),
    MV("mv", 128L),
    HV("hv", 1024L),
    EV("ev", 8192L),
    SUPERCONDUCTOR("superconductor", 128000000L);

    public final String name;
    public final long eu;
    public final String translationKey;

    private CableTier(String name, long eu) {
        this.name = name;
        this.eu = eu;
        this.translationKey = "text.modern_industrialization.cable_tier_" + name;
    }

    public long getMaxTransfer() {
        return this.eu * 8L;
    }

    public long getEu() {
        return this.eu;
    }

    public String toString() {
        return this.name;
    }

    public static final CableTier getTier(String name) {
        for (CableTier tier : CableTier.values()) {
            if (!tier.name.equals(name)) continue;
            return tier;
        }
        return null;
    }
}

