/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client.model;

import aztech.modern_industrialization.client.model.MachineBakedModel;
import aztech.modern_industrialization.machines.models.MachineCasing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_793;
import net.minecraft.class_809;
import org.jetbrains.annotations.Nullable;

public class MachineUnbakedModel
implements class_1100 {
    private static final class_2960 BASE_BLOCK_MODEL = new class_2960("minecraft:block/block");
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).create();
    private final MachineCasing baseCasing;
    private final class_4730[] defaultOverlays;
    private final Map<String, class_4730[]> tieredOverlays = new HashMap<String, class_4730[]>();

    public static MachineUnbakedModel deserialize(MachineCasing baseCasing, class_3298 jsonModel) {
        InputStreamReader stream = new InputStreamReader(jsonModel.method_14482(), StandardCharsets.UTF_8);
        JsonElement element = JsonParser.parseReader((Reader)stream);
        return new MachineUnbakedModel(baseCasing, element.getAsJsonObject());
    }

    private MachineUnbakedModel(MachineCasing baseCasing, JsonObject obj) {
        this.baseCasing = baseCasing;
        OverlaysJson defaultOverlaysJson = OverlaysJson.parse(class_3518.method_15296((JsonObject)obj, (String)"default_overlays"), null);
        this.defaultOverlays = defaultOverlaysJson.toSpriteIds();
        JsonObject tieredOverlays = class_3518.method_15281((JsonObject)obj, (String)"tiered_overlays", (JsonObject)new JsonObject());
        for (String casingTier : tieredOverlays.keySet()) {
            OverlaysJson casingOverlaysJson = OverlaysJson.parse(class_3518.method_15296((JsonObject)tieredOverlays, (String)casingTier), defaultOverlaysJson);
            this.tieredOverlays.put(casingTier, casingOverlaysJson.toSpriteIds());
        }
    }

    public Collection<class_2960> method_4755() {
        return List.of(BASE_BLOCK_MODEL);
    }

    public Collection<class_4730> method_4754(Function<class_2960, class_1100> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
        HashSet<class_4730> set = new HashSet<class_4730>(Arrays.asList(this.defaultOverlays));
        for (class_4730[] tierSprites : this.tieredOverlays.values()) {
            set.addAll(Arrays.asList(tierSprites));
        }
        set.remove(null);
        return set;
    }

    @Nullable
    public class_1087 method_4753(class_1088 loader, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
        class_809 blockTransformation = ((class_793)loader.method_4726(BASE_BLOCK_MODEL)).method_3443();
        RenderMaterial cutoutMaterial = RendererAccess.INSTANCE.getRenderer().materialFinder().blendMode(0, BlendMode.CUTOUT_MIPPED).find();
        class_1058[] defaultOverlays = MachineUnbakedModel.loadSprites(textureGetter, this.defaultOverlays);
        HashMap<String, class_1058[]> tieredOverlays = new HashMap<String, class_1058[]>();
        for (Map.Entry<String, class_4730[]> entry : this.tieredOverlays.entrySet()) {
            tieredOverlays.put(entry.getKey(), MachineUnbakedModel.loadSprites(textureGetter, entry.getValue()));
        }
        return new MachineBakedModel(blockTransformation, cutoutMaterial, this.baseCasing, defaultOverlays, tieredOverlays);
    }

    private static class_1058[] loadSprites(Function<class_4730, class_1058> textureGetter, class_4730[] ids) {
        class_1058[] sprites = new class_1058[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == null) continue;
            sprites[i] = textureGetter.apply(ids[i]);
        }
        return sprites;
    }

    private static class OverlaysJson {
        private class_2960 top;
        private class_2960 top_active;
        private class_2960 side;
        private class_2960 side_active;
        private class_2960 bottom;
        private class_2960 bottom_active;
        private class_2960 front;
        private class_2960 front_active;
        private class_2960 left;
        private class_2960 left_active;
        private class_2960 right;
        private class_2960 right_active;
        private class_2960 back;
        private class_2960 back_active;
        private class_2960 top_s;
        private class_2960 top_s_active;
        private class_2960 top_w;
        private class_2960 top_w_active;
        private class_2960 top_n;
        private class_2960 top_n_active;
        private class_2960 top_e;
        private class_2960 top_e_active;
        private class_2960 bottom_s;
        private class_2960 bottom_s_active;
        private class_2960 bottom_w;
        private class_2960 bottom_w_active;
        private class_2960 bottom_n;
        private class_2960 bottom_n_active;
        private class_2960 bottom_e;
        private class_2960 bottom_e_active;
        private class_2960 output;
        private class_2960 item_auto;
        private class_2960 fluid_auto;

        private OverlaysJson() {
        }

        private static OverlaysJson parse(JsonObject json, @Nullable OverlaysJson defaultOverlay) {
            OverlaysJson overlays = (OverlaysJson)GSON.fromJson((JsonElement)json, OverlaysJson.class);
            if (defaultOverlay != null) {
                try {
                    for (Field field : OverlaysJson.class.getDeclaredFields()) {
                        if (field.get(overlays) != null) continue;
                        field.set(overlays, field.get(defaultOverlay));
                    }
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("Failed to copy fields from default overlay", ex);
                }
            }
            return overlays;
        }

        private class_4730[] toSpriteIds() {
            return new class_4730[]{OverlaysJson.select(this.front, this.side), OverlaysJson.select(this.front_active, this.front, this.side_active, this.side), OverlaysJson.select(this.left, this.side), OverlaysJson.select(this.left_active, this.left, this.side_active, this.side), OverlaysJson.select(this.back, this.side), OverlaysJson.select(this.back_active, this.back, this.side_active, this.side), OverlaysJson.select(this.right, this.side), OverlaysJson.select(this.right_active, this.right, this.side_active, this.side), OverlaysJson.select(this.top_s, this.top), OverlaysJson.select(this.top_s_active, this.top_s, this.top_active, this.top), OverlaysJson.select(this.top_w, this.top), OverlaysJson.select(this.top_w_active, this.top_w, this.top_active, this.top), OverlaysJson.select(this.top_n, this.top), OverlaysJson.select(this.top_n_active, this.top_n, this.top_active, this.top), OverlaysJson.select(this.top_e, this.top), OverlaysJson.select(this.top_e_active, this.top_e, this.top_active, this.top), OverlaysJson.select(this.bottom_s, this.bottom), OverlaysJson.select(this.bottom_s_active, this.bottom_s, this.bottom_active, this.bottom), OverlaysJson.select(this.bottom_w, this.bottom), OverlaysJson.select(this.bottom_w_active, this.bottom_w, this.bottom_active, this.bottom), OverlaysJson.select(this.bottom_n, this.bottom), OverlaysJson.select(this.bottom_n_active, this.bottom_n, this.bottom_active, this.bottom), OverlaysJson.select(this.bottom_e, this.bottom), OverlaysJson.select(this.bottom_e_active, this.bottom_e, this.bottom_active, this.bottom), OverlaysJson.select(this.output), OverlaysJson.select(this.item_auto), OverlaysJson.select(this.fluid_auto)};
        }

        @Nullable
        private static class_4730 select(class_2960 ... candidates) {
            for (class_2960 id : candidates) {
                if (id == null) continue;
                return new class_4730(class_1723.field_21668, id);
            }
            return null;
        }
    }
}

