/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.rei.machines;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.compat.rei.machines.MachineCategoryParams;
import aztech.modern_industrialization.compat.rei.machines.MachineRecipeDisplay;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.components.sync.EnergyBar;
import aztech.modern_industrialization.machines.components.sync.ProgressBar;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_4587;

public class MachineRecipeCategory
implements DisplayCategory<MachineRecipeDisplay> {
    private final class_2960 id;
    private final MachineCategoryParams params;

    public MachineRecipeCategory(class_2960 id, MachineCategoryParams params) {
        this.id = id;
        this.params = params;
    }

    public CategoryIdentifier<? extends MachineRecipeDisplay> getCategoryIdentifier() {
        return CategoryIdentifier.of((class_2960)this.id);
    }

    public class_2561 getTitle() {
        return new class_2588("rei_categories.modern_industrialization." + this.id.method_12832());
    }

    public Renderer getIcon() {
        return EntryStacks.of((class_1935)((class_1935)class_2378.field_11142.method_10223((class_2960)new MIIdentifier(this.params.workstations.get(0)))));
    }

    public List<Widget> setupDisplay(MachineRecipeDisplay recipeDisplay, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int x = 1000;
        int X = 0;
        int y = 1000;
        int Y = 0;
        for (SlotPositions positions2 : new SlotPositions[]{this.params.itemInputs, this.params.itemOutputs, this.params.fluidInputs, this.params.fluidOutputs}) {
            for (int i = 0; i < positions2.size(); ++i) {
                x = Math.min(x, positions2.getX(i));
                X = Math.max(X, positions2.getX(i) + 16);
                y = Math.min(y, positions2.getY(i));
                Y = Math.max(Y, positions2.getY(i) + 16);
            }
        }
        int xoffset = bounds.x + (bounds.width - X + x) / 2 - x;
        int yoffset = bounds.y + 17 - y;
        SlotDrawer drawer = (entryStream, positions, input, fluid) -> {
            List entries = entryStream.collect(Collectors.toList());
            for (int i = 0; i < positions.size(); ++i) {
                EntryIngredient ingredient = i < entries.size() ? (EntryIngredient)entries.get(i) : EntryIngredient.empty();
                Point point = new Point(xoffset + positions.getX(i), yoffset + positions.getY(i));
                Slot widget = Widgets.createSlot((Point)point).entries((Collection)ingredient);
                if (input) {
                    widget.markInput();
                } else {
                    widget.markOutput();
                }
                if (fluid) {
                    widgets.add(MachineRecipeCategory.createFluidSlotBackground(point));
                    widget.disableBackground();
                }
                widgets.add((Widget)widget);
            }
        };
        drawer.drawSlots(recipeDisplay.getItemInputs(), this.params.itemInputs, true, false);
        drawer.drawSlots(recipeDisplay.getItemOutputs(), this.params.itemOutputs, false, false);
        drawer.drawSlots(recipeDisplay.getFluidInputs(), this.params.fluidInputs, true, true);
        drawer.drawSlots(recipeDisplay.getFluidOutputs(), this.params.fluidOutputs, false, true);
        double recipeMillis = recipeDisplay.getSeconds() * 1000.0;
        widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> ProgressBar.RenderHelper.renderProgress(helper, matrices, xoffset, yoffset, this.params.progressBarParams, (float)((double)System.currentTimeMillis() / recipeMillis % 1.0))));
        class_2588 totalEuTooltip = new class_2588("text.modern_industrialization.base_eu_total", new Object[]{TextHelper.getEuText(recipeDisplay.getTicks() * recipeDisplay.getEu())});
        widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            matrices.method_22903();
            matrices.method_22904((double)(bounds.x + 5), (double)(bounds.y + 5), 0.0);
            matrices.method_22905(0.5f, 0.5f, 0.5f);
            EnergyBar.Client.Renderer.renderEnergy(helper, matrices, 0, 0, 1.0f);
            matrices.method_22909();
        }));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.x + 15, bounds.y + 5), (class_2561)TextHelper.getEuTextTick(recipeDisplay.getEu())).leftAligned().noShadow().color(-12566464, -4473925));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.getMaxX() - 5, bounds.y + 5), (class_2561)new class_2588("text.modern_industrialization.base_duration_seconds", new Object[]{recipeDisplay.getSeconds()})).rightAligned().noShadow().color(-12566464, -4473925));
        final Rectangle tooltipZone = new Rectangle(bounds.x + 2, bounds.y + 5, bounds.width - 10, 12);
        widgets.add(new Widget((class_2561)totalEuTooltip){
            final /* synthetic */ class_2561 val$totalEuTooltip;
            {
                this.val$totalEuTooltip = class_25612;
            }

            public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
                if (tooltipZone.contains(mouseX, mouseY)) {
                    Tooltip.create((class_2561[])new class_2561[]{this.val$totalEuTooltip}).queue();
                }
            }

            public List<? extends class_364> method_25396() {
                return Collections.emptyList();
            }
        });
        return widgets;
    }

    public int getDisplayHeight() {
        int y = 1000;
        int Y = 0;
        for (SlotPositions positions : new SlotPositions[]{this.params.itemInputs, this.params.itemOutputs, this.params.fluidInputs, this.params.fluidOutputs}) {
            for (int i = 0; i < positions.size(); ++i) {
                y = Math.min(y, positions.getY(i));
                Y = Math.max(Y, positions.getY(i) + 16);
            }
        }
        return Y - y + 25;
    }

    public int getDisplayWidth(MachineRecipeDisplay display) {
        int x = 1000;
        int X = 0;
        for (SlotPositions positions : new SlotPositions[]{this.params.itemInputs, this.params.itemOutputs, this.params.fluidInputs, this.params.fluidOutputs}) {
            for (int i = 0; i < positions.size(); ++i) {
                x = Math.min(x, positions.getX(i));
                X = Math.max(X, positions.getX(i) + 16);
            }
        }
        return Math.max(X - x + 15, 120);
    }

    private static Widget createFluidSlotBackground(Point point) {
        return Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
            helper.method_25302(matrices, point.x - 1, point.y - 1, 18, 0, 18, 18);
        });
    }

    @FunctionalInterface
    private static interface SlotDrawer {
        public void drawSlots(Stream<EntryIngredient> var1, SlotPositions var2, boolean var3, boolean var4);
    }
}

