/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.rei.nuclear;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.compat.rei.ReiUtil;
import aztech.modern_industrialization.compat.rei.nuclear.NeutronInteractionDisplay;
import aztech.modern_industrialization.compat.rei.nuclear.NeutronInteractionPlugin;
import aztech.modern_industrialization.nuclear.INuclearComponent;
import aztech.modern_industrialization.nuclear.NeutronInteraction;
import aztech.modern_industrialization.nuclear.NeutronType;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class NeutronInteractionCategory
implements DisplayCategory<NeutronInteractionDisplay> {
    public static final class_2960 TEXTURE_ATLAS = new class_2960("modern_industrialization", "textures/gui/rei/texture_atlas.png");
    private static final class_2960 PROGRESS_BAR = new MIIdentifier("textures/gui/progress_bar/long_arrow.png");

    public CategoryIdentifier<? extends NeutronInteractionDisplay> getCategoryIdentifier() {
        return NeutronInteractionPlugin.NEUTRON_CATEGORY;
    }

    public Renderer getIcon() {
        return EntryStacks.of((class_1935)((class_1935)class_2378.field_11142.method_10223((class_2960)new MIIdentifier("uranium_fuel_rod"))));
    }

    public class_2561 getTitle() {
        return new class_2588("text.modern_industrialization.neutron_interaction");
    }

    public List<Widget> displayNeutronScattering(NeutronInteractionDisplay display, Rectangle bounds) {
        class_2588 title;
        NeutronType type;
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int centerY = bounds.y + bounds.height / 2 - 5;
        int centerX = bounds.x + 66;
        Object t = display.nuclearComponent.getVariant();
        if (t instanceof ItemVariant) {
            ItemVariant itemVariant = (ItemVariant)t;
            widgets.add((Widget)Widgets.createSlot((Point)new Point(centerX, centerY)).entry(EntryStacks.of((class_1935)itemVariant.getItem())));
        } else {
            t = display.nuclearComponent.getVariant();
            if (t instanceof FluidVariant) {
                FluidVariant fluidVariant = (FluidVariant)t;
                widgets.add((Widget)Widgets.createSlot((Point)new Point(centerX, centerY)).entry(ReiUtil.createFluidEntryStack(fluidVariant.getFluid())));
            }
        }
        if (display.type == NeutronInteractionDisplay.CategoryType.FAST_NEUTRON_INTERACTION) {
            type = NeutronType.FAST;
            title = new class_2588("text.modern_industrialization.fast_neutron");
            widgets.add(Widgets.createTexturedWidget((class_2960)TEXTURE_ATLAS, (int)(centerX - 53), (int)(centerY - 19), (float)0.0f, (float)0.0f, (int)88, (int)54));
        } else {
            type = NeutronType.THERMAL;
            title = new class_2588("text.modern_industrialization.thermal_neutron");
            widgets.add(Widgets.createTexturedWidget((class_2960)TEXTURE_ATLAS, (int)(centerX - 53), (int)(centerY - 19), (float)0.0f, (float)54.0f, (int)88, (int)54));
        }
        double interactionProb = display.nuclearComponent.getNeutronBehaviour().interactionTotalProbability(type);
        double scattering = display.nuclearComponent.getNeutronBehaviour().interactionRelativeProbability(type, NeutronInteraction.SCATTERING);
        double absorption = display.nuclearComponent.getNeutronBehaviour().interactionRelativeProbability(type, NeutronInteraction.ABSORPTION);
        widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX + 10, centerY - 30), (class_2561)title));
        String scatteringString = String.format("%.1f ", 100.0 * interactionProb * scattering) + "%";
        String absorptionString = String.format("%.1f ", 100.0 * interactionProb * absorption) + "%";
        widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX - 20, centerY - 15), (class_2561)new class_2585(scatteringString)).tooltipLine(new class_2588("text.modern_industrialization.scattering_probability").getString()));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX + 30, centerY + 35), (class_2561)new class_2585(absorptionString).method_10862(TextHelper.NEUTRONS)).noShadow().tooltipLine(new class_2588("text.modern_industrialization.absorption_probability").getString()));
        if (type == NeutronType.FAST) {
            double slowingProba = display.nuclearComponent.getNeutronBehaviour().neutronSlowingProbability();
            String thermalFractionString = String.format("%.1f ", 100.0 * slowingProba) + "%";
            String fastFractionString = String.format("%.1f ", 100.0 * (1.0 - slowingProba)) + "%";
            widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX + 60, centerY + 20), (class_2561)new class_2585(fastFractionString).method_10862(class_2583.field_24360.method_36139(12327450))).noShadow().tooltipLine(new class_2588("text.modern_industrialization.fast_neutron_fraction").getString()));
            widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX + 60, centerY - 10), (class_2561)new class_2585(thermalFractionString).method_10862(class_2583.field_24360.method_36139(796583))).noShadow().tooltipLine(new class_2588("text.modern_industrialization.thermal_neutron_fraction").getString()));
            int index = 1 + (int)Math.floor(slowingProba * 9.0);
            if (slowingProba == 0.0) {
                index = 0;
            } else if (slowingProba == 1.0) {
                index = 10;
            }
            widgets.add(Widgets.createTexturedWidget((class_2960)TEXTURE_ATLAS, (int)(centerX + 48), (int)centerY, (float)(index * 16), (float)240.0f, (int)16, (int)16));
        }
        return widgets;
    }

    public List<Widget> displayNeutronFission(NeutronInteractionDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int centerY = bounds.y + bounds.height / 2 - 5;
        int centerX = bounds.x + 52;
        NuclearFuel fuel = (NuclearFuel)display.nuclearComponent;
        widgets.add((Widget)Widgets.createSlot((Point)new Point(centerX, centerY)).entry(EntryStacks.of((class_1935)fuel)));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX + 20, centerY - 30), (class_2561)new class_2588("text.modern_industrialization.single_neutron_capture")));
        widgets.add(Widgets.createTexturedWidget((class_2960)TEXTURE_ATLAS, (int)(centerX - 28), (int)(centerY - 7), (float)0.0f, (float)109.0f, (int)92, (int)31));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX + 20, centerY + 35), (class_2561)new class_2588("text.modern_industrialization.neutrons_multiplication", new Object[]{String.format("%.1f", fuel.neutronMultiplicationFactor)}).method_10862(TextHelper.NEUTRONS)).noShadow().tooltipLine(new class_2588("text.modern_industrialization.neutron_temperature_variation").getString()));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX - 18, centerY + 23), (class_2561)new class_2585(String.format("%d EU", 8)).method_10862(TextHelper.NEUTRONS)).noShadow().tooltipLine(new class_2588("text.modern_industrialization.fast_neutron_energy").getString()));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX + 55, centerY + 23), (class_2561)new class_2585(String.format("%d EU", fuel.directEUbyDesintegration))).tooltipLine(new class_2588("text.modern_industrialization.direct_energy").getString()));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX + 55, centerY - 12), (class_2561)new class_2585(String.format("%.2f \u00b0C", (double)fuel.directEUbyDesintegration / 64.0))).tooltipLine(new class_2588("text.modern_industrialization.direct_heat_by_desintegration").getString()));
        return widgets;
    }

    public List<Widget> displayNeutronProduct(NeutronInteractionDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        int centerY = bounds.y + bounds.height / 2 - 5;
        int centerX = bounds.x + 66;
        float probability = (float)display.nuclearComponent.getNeutronProductProbability();
        long amount = display.nuclearComponent.getNeutronProductAmount();
        int neutronNumber = 1;
        Object t = display.nuclearComponent.getVariant();
        if (t instanceof ItemVariant) {
            ItemVariant itemVariant = (ItemVariant)t;
            widgets.add((Widget)Widgets.createSlot((Point)new Point(centerX - 35, centerY)).entry(EntryStacks.of((class_1935)itemVariant.getItem())));
            product = (ItemVariant)display.nuclearComponent.getNeutronProduct();
            widgets.add((Widget)Widgets.createSlot((Point)new Point(centerX + 35, centerY)).entry(EntryStacks.of((class_1935)product.getItem(), (int)((int)amount))));
            INuclearComponent iNuclearComponent = display.nuclearComponent;
            if (iNuclearComponent instanceof NuclearFuel) {
                NuclearFuel nuclearFuel = (NuclearFuel)iNuclearComponent;
                neutronNumber = nuclearFuel.desintegrationMax;
            }
        } else {
            product = display.nuclearComponent.getVariant();
            if (product instanceof FluidVariant) {
                FluidVariant fluidVariant = (FluidVariant)product;
                widgets.add((Widget)Widgets.createSlot((Point)new Point(centerX - 35, centerY)).entry(ReiUtil.createFluidEntryStack(fluidVariant.getFluid(), 1L, probability)));
                product = (FluidVariant)display.nuclearComponent.getNeutronProduct();
                widgets.add((Widget)Widgets.createSlot((Point)new Point(centerX + 35, centerY)).entry(ReiUtil.createFluidEntryStack(product.getFluid(), amount, probability)));
            }
        }
        class_2588 title = new class_2588("text.modern_industrialization.neutron_absorption");
        widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX + 10, centerY - 30), (class_2561)title));
        widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            RenderSystem.setShaderTexture((int)0, (class_2960)PROGRESS_BAR);
            int posX = centerX - 12;
            int posY = centerY - 2;
            class_332.method_25291((class_4587)matrices, (int)posX, (int)posY, (int)helper.method_25305(), (float)0.0f, (float)0.0f, (int)40, (int)20, (int)40, (int)40);
            class_332.method_25291((class_4587)matrices, (int)posX, (int)posY, (int)helper.method_25305(), (float)0.0f, (float)20.0f, (int)((int)((double)(40L * (System.currentTimeMillis() % 3000L)) / 3000.0)), (int)20, (int)40, (int)40);
        }));
        class_2588 neutronNumberText = neutronNumber > 1 ? new class_2588("text.modern_industrialization.neutrons", new Object[]{neutronNumber}) : new class_2588("text.modern_industrialization.neutron", new Object[]{neutronNumber});
        widgets.add((Widget)Widgets.createLabel((Point)new Point(centerX + 10, centerY + 20), (class_2561)neutronNumberText));
        return widgets;
    }

    public List<Widget> setupDisplay(NeutronInteractionDisplay display, Rectangle bounds) {
        if (display.type == NeutronInteractionDisplay.CategoryType.FISSION) {
            return this.displayNeutronFission(display, bounds);
        }
        if (display.type == NeutronInteractionDisplay.CategoryType.NEUTRON_PRODUCT) {
            return this.displayNeutronProduct(display, bounds);
        }
        return this.displayNeutronScattering(display, bounds);
    }

    public int getDisplayHeight() {
        return 90;
    }
}

