/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2405;
import net.minecraft.class_2408;

public class MachineModelsProvider
implements class_2405 {
    private static final Map<String, MachineModelProperties> PROPS = new HashMap<String, MachineModelProperties>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final FabricDataGenerator gen;

    public static void register(String machine, String overlay, boolean front, boolean top, boolean side, boolean active) {
        PROPS.put(machine, new MachineModelProperties(overlay, front, top, side, active));
    }

    public MachineModelsProvider(FabricDataGenerator gen) {
        this.gen = gen;
    }

    public void method_10319(class_2408 cache) throws IOException {
        Path outputPath = this.gen.method_10313();
        Path nonGeneratedPath = this.gen.method_10313().resolve("../../main/resources");
        for (Map.Entry<String, MachineModelProperties> entry : PROPS.entrySet()) {
            String modelPath = "assets/%s/models/machine/%s.json".formatted(this.gen.getModId(), entry.getKey());
            if (Files.exists(nonGeneratedPath.resolve(modelPath), new LinkOption[0])) continue;
            class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)entry.getValue().toMachineJson(), (Path)outputPath.resolve(modelPath));
        }
    }

    public String method_10321() {
        return "Machine Models Provider";
    }

    private record MachineModelProperties(String overlay, boolean front, boolean top, boolean side, boolean active) {
        private JsonObject toMachineJson() {
            JsonObject obj = new JsonObject();
            JsonObject defaultOverlays = new JsonObject();
            if (this.top) {
                defaultOverlays.addProperty("top", "modern_industrialization:blocks/machines/%s/overlay_top".formatted(this.overlay));
                if (this.active) {
                    defaultOverlays.addProperty("top_active", "modern_industrialization:blocks/machines/%s/overlay_top_active".formatted(this.overlay));
                }
            }
            if (this.front) {
                defaultOverlays.addProperty("front", "modern_industrialization:blocks/machines/%s/overlay_front".formatted(this.overlay));
                if (this.active) {
                    defaultOverlays.addProperty("front_active", "modern_industrialization:blocks/machines/%s/overlay_front_active".formatted(this.overlay));
                }
            }
            if (this.side) {
                defaultOverlays.addProperty("side", "modern_industrialization:blocks/machines/%s/overlay_side".formatted(this.overlay));
                if (this.active) {
                    defaultOverlays.addProperty("side_active", "modern_industrialization:blocks/machines/%s/overlay_side_active".formatted(this.overlay));
                }
            }
            defaultOverlays.addProperty("output", "modern_industrialization:blocks/overlays/output");
            defaultOverlays.addProperty("item_auto", "modern_industrialization:blocks/overlays/item_auto");
            defaultOverlays.addProperty("fluid_auto", "modern_industrialization:blocks/overlays/fluid_auto");
            obj.add("default_overlays", (JsonElement)defaultOverlays);
            return obj;
        }
    }
}

