/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.MaterialRegistry;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.recipe.json.MIRecipeJson;
import aztech.modern_industrialization.recipe.json.RecipeJson;
import aztech.modern_industrialization.recipe.json.compat.IRCompressRecipeJson;
import aztech.modern_industrialization.recipe.json.compat.TRCompressorRecipeJson;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.class_2444;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class CompatRecipesProvider
extends MIRecipesProvider {
    private Consumer<class_2444> consumer;
    private String currentCompatModid;

    public CompatRecipesProvider(FabricDataGenerator dataGenerator) {
        super(dataGenerator);
    }

    protected void generateRecipes(Consumer<class_2444> consumer) {
        this.consumer = consumer;
        this.currentCompatModid = "techreborn";
        this.generateTrCompat();
        this.currentCompatModid = "ae2";
        this.generateAe2Compat();
        this.currentCompatModid = "indrev";
        this.generateIndrevCompat();
    }

    private void generateTrCompat() {
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:advanced_alloy_ingot", "techreborn:advanced_alloy_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "#c:brass_ingots", "techreborn:brass_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:carbon_mesh", "techreborn:carbon_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:lazurite_dust", "techreborn:lazurite_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "minecraft:obsidian", "techreborn:obsidian_plate", 9);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:obsidian_dust", "techreborn:obsidian_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "#c:peridot_dusts", "techreborn:peridot_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:plantball", "techreborn:compressed_plantball", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "minecraft:prismarine_crystals", "minecraft:prismarine_shard", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:red_garnet_dust", "techreborn:red_garnet_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "minecraft:redstone_block", "techreborn:redstone_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "#c:ruby_dusts", "techreborn:ruby_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "#c:sapphire_dusts", "techreborn:sapphire_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:tungstensteel_ingot", "techreborn:tungstensteel_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "#minecraft:planks", "techreborn:wood_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:yellow_garnet_dust", "techreborn:yellow_garnet_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "#c:zinc_ingots", "techreborn:zinc_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.COMPRESSOR, "techreborn:refined_iron_ingot", "techreborn:refined_iron_plate", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:andesite", "techreborn:andesite_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:basalt", "techreborn:basalt_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:brass_ingots", "techreborn:brass_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:charcoal", "techreborn:charcoal_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:cinnabar_ores", "techreborn:cinnabar_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:clay_ball", "techreborn:clay_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:diorite", "techreborn:diorite_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:ender_eye", "techreborn:ender_eye_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:ender_pearl", "techreborn:ender_pearl_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:end_stone", "techreborn:endstone_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:flint", "techreborn:flint_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:galena_ores", "techreborn:galena_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:granite", "techreborn:granite_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "minecraft:netherrack", "techreborn:netherrack_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "techreborn:peridot_gem", "techreborn:peridot_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:peridot_ores", "techreborn:peridot_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:pyrite_ores", "techreborn:pyrite_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "techreborn:red_garnet_gem", "techreborn:red_garnet_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "techreborn:ruby_gem", "modern_industrialization:ruby_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:ruby_ores", "modern_industrialization:ruby_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "techreborn:sapphire_gem", "techreborn:sapphire_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:sapphire_ores", "techreborn:sapphire_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:sodalite_ores", "techreborn:sodalite_dust", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "techreborn:yellow_garnet_gem", "techreborn:yellow_garnet_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:zinc_ingots", "techreborn:zinc_dust", 1);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:silver_ores", "techreborn:raw_silver", 2);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:sphalerite_ores", "techreborn:sphalerite_dust", 2);
        for (Material material : MaterialRegistry.getMaterials().values()) {
            if (!material.getParts().containsKey(MIParts.CURVED_PLATE.key)) continue;
            String plate = material.name;
            this.addCompatRecipe("%s_curved_plate".formatted(plate), new TRCompressorRecipeJson("c:%s_plates".formatted(plate), "modern_industrialization:%s_curved_plate".formatted(plate)));
        }
    }

    private void generateAe2Compat() {
        this.addMiRecipe(MIMachineRecipeTypes.ELECTROLYZER, "ae2:certus_quartz_crystal", "ae2:charged_certus_quartz_crystal", 1, 8, 60);
        this.addCompatRecipe("macerator/certus_ore", MIRecipeJson.create(MIMachineRecipeTypes.MACERATOR, 2, 200).addItemInput("#c:certus_quartz_ores", 1).addItemOutput("ae2:certus_quartz_dust", 5).addItemOutput("ae2:certus_quartz_crystal", 1, 0.1));
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:certus_quartz", "ae2:certus_quartz_dust", 1, 2, 100);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "ae2:fluix_crystal", "ae2:fluix_dust", 1, 2, 100);
        this.addCompatRecipe("mixer/fluix", MIRecipeJson.create(MIMachineRecipeTypes.MIXER, 8, 100).addItemInput("minecraft:quartz", 1).addItemInput("ae2:charged_certus_quartz_crystal", 1).addItemInput("minecraft:redstone", 1).addFluidInput((class_3611)class_3612.field_15910, 1000, 0.0).addItemOutput("ae2:fluix_dust", 2));
        this.addCompatRecipe("quarry_ae2", MIRecipeJson.create(MIMachineRecipeTypes.QUARRY, 16, 600).addItemInput("ae2:fluix_glass_cable", 1, 0.2).addItemOutput("ae2:quartz_ore", 8, 0.02));
    }

    private void generateIndrevCompat() {
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "indrev:nikolite_ore", "indrev:nikolite_dust", 7);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "indrev:deepslate_nikolite_ore", "indrev:nikolite_dust", 7);
        this.addMiRecipe(MIMachineRecipeTypes.MACERATOR, "#c:silver_ores", "indrev:raw_silver", 2);
        this.addCompatRecipe("quarry_nikolite", MIRecipeJson.create(MIMachineRecipeTypes.QUARRY, 16, 600).addItemInput("indrev:cable_mk1", 1, 0.6).addItemOutput("indrev:nikolite_ore", 6, 0.03));
        for (Material material : MaterialRegistry.getMaterials().values()) {
            if (!material.getParts().containsKey(MIParts.CURVED_PLATE.key) || material.name.equals("tin")) continue;
            String plate = material.name;
            this.addCompatRecipe("%s_curved_plate".formatted(plate), new IRCompressRecipeJson("c:%s_plates".formatted(plate), "modern_industrialization:%s_curved_plate".formatted(plate)));
        }
    }

    private void addMiRecipe(MachineRecipeType machine, String input, String output, int outputAmount) {
        this.addMiRecipe(machine, input, output, outputAmount, 2, 200);
    }

    private void addMiRecipe(MachineRecipeType machine, String input, String output, int outputAmount, int eu, int duration) {
        String id = "%s/%s_to_%s".formatted(machine.getPath(), input.replace('#', '_').replace(':', '_'), output.replace(':', '_'));
        this.addCompatRecipe(id, MIRecipeJson.create(machine, eu, duration).addItemInput(input, 1).addItemOutput(output, outputAmount));
    }

    private void addCompatRecipe(String id, RecipeJson<?> recipeJson) {
        id = "compat/%s/%s".formatted(this.currentCompatModid, id);
        recipeJson.offerTo(this.withConditions(this.consumer, new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{this.currentCompatModid})}), id);
    }
}

