/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.recipe;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.datagen.recipe.MIRecipesProvider;
import aztech.modern_industrialization.fluid.CraftingFluid;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.recipe.json.MIRecipeJson;
import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public class PetrochemRecipesProvider
extends MIRecipesProvider {
    public PetrochemRecipesProvider(FabricDataGenerator dataGenerator) {
        super(dataGenerator);
    }

    protected void generateRecipes(Consumer<class_2444> consumer) {
        this.generateDistillation(consumer, 12, 200, PetrochemRecipesProvider.f(MIFluids.CRUDE_OIL, 1000), PetrochemRecipesProvider.f(MIFluids.SULFURIC_LIGHT_FUEL, 500), PetrochemRecipesProvider.f(MIFluids.SULFURIC_HEAVY_FUEL, 200), PetrochemRecipesProvider.f(MIFluids.SULFURIC_NAPHTHA, 300));
        this.generateDistillation(consumer, 15, 200, PetrochemRecipesProvider.f(MIFluids.STEAM_CRACKED_NAPHTHA, 1000), PetrochemRecipesProvider.f(MIFluids.METHANE, 150), PetrochemRecipesProvider.f(MIFluids.ACETYLENE, 50), PetrochemRecipesProvider.f(MIFluids.ETHYLENE, 250), PetrochemRecipesProvider.f(MIFluids.PROPENE, 75), PetrochemRecipesProvider.f(MIFluids.BUTADIENE, 125), PetrochemRecipesProvider.f(MIFluids.BENZENE, 150), PetrochemRecipesProvider.f(MIFluids.TOLUENE, 100), PetrochemRecipesProvider.f(MIFluids.ETHYLBENZENE, 100));
        this.generateDistillation(consumer, 10, 200, PetrochemRecipesProvider.f(MIFluids.SHALE_OIL, 1000), PetrochemRecipesProvider.f(MIFluids.HELIUM, 50), PetrochemRecipesProvider.f(MIFluids.SULFURIC_CRUDE_OIL, 450), PetrochemRecipesProvider.f(MIFluids.SULFURIC_NAPHTHA, 500));
        this.generateSulfuricPurification(consumer, MIFluids.CRUDE_OIL);
        this.generateSulfuricPurification(consumer, MIFluids.HEAVY_FUEL);
        this.generateSulfuricPurification(consumer, MIFluids.LIGHT_FUEL);
        this.generateSulfuricPurification(consumer, MIFluids.NAPHTHA);
        this.generatePolymerization(consumer, MIFluids.ETHYLENE, MIFluids.POLYETHYLENE);
        this.generatePolymerization(consumer, MIFluids.VINYL_CHLORIDE, MIFluids.POLYVINYL_CHLORIDE);
        this.generatePolymerization(consumer, MIFluids.CAPROLACTAM, MIFluids.NYLON);
        this.generatePolymerization(consumer, MIFluids.ACRYLIC_ACID, MIFluids.ACRYLIC_GLUE);
        this.generatePolymerization(consumer, MIFluids.STYRENE_BUTADIENE, MIFluids.STYRENE_BUTADIENE_RUBBER);
    }

    private void generateDistillation(Consumer<class_2444> consumer, int eu, int duration, FluidEntry input, FluidEntry ... outputs) {
        String basePath = "petrochem/distillation/" + class_2378.field_11154.method_10221((Object)input.fluid).method_12832() + "_";
        MIRecipeJson full = MIRecipeJson.create(MIMachineRecipeTypes.DISTILLATION_TOWER, eu * outputs.length, duration);
        full.addFluidInput(input.fluid, input.amount);
        for (FluidEntry output : outputs) {
            full.addFluidOutput(output.fluid, output.amount);
        }
        full.offerTo(consumer, basePath + "full");
        for (int i = 0; i < outputs.length; ++i) {
            FluidEntry output = outputs[i];
            MIRecipeJson.create(MIMachineRecipeTypes.DISTILLERY, eu, duration).addFluidInput(input.fluid, input.amount).addFluidOutput(output.fluid, output.amount).offerTo(consumer, basePath + i);
        }
    }

    private void generateSulfuricPurification(Consumer<class_2444> consumer, class_3611 purifiedFluid) {
        String baseName = class_2378.field_11154.method_10221((Object)purifiedFluid).method_12832();
        class_3611 sulfuricFluid = (class_3611)class_2378.field_11154.method_10223((class_2960)new MIIdentifier("sulfuric_" + baseName));
        Preconditions.checkArgument((boolean)(sulfuricFluid instanceof CraftingFluid));
        MIRecipeJson.create(MIMachineRecipeTypes.CHEMICAL_REACTOR, 16, 400).addFluidInput(sulfuricFluid, 12000).addFluidInput(MIFluids.HYDROGEN, 2000).addFluidOutput(purifiedFluid, 12000).addFluidOutput(MIFluids.SULFURIC_ACID, 2000).offerTo(consumer, "petrochem/sulfuric_purification/" + baseName);
    }

    private void generatePolymerization(Consumer<class_2444> consumer, class_3611 input, class_3611 output) {
        String baseNameInput = class_2378.field_11154.method_10221((Object)input).method_12832();
        for (PolymerizationKind kind : PolymerizationKind.values()) {
            MIRecipeJson.create(MIMachineRecipeTypes.CHEMICAL_REACTOR, 12, 700).addItemInput("#c:" + kind.catalystMaterial + "_tiny_dusts", kind.inputTinyDust).addFluidInput(input, 500).addFluidOutput(output, kind.outputMillis).offerTo(consumer, "petrochem/polymerization/" + baseNameInput + "_" + kind.name().toLowerCase());
        }
    }

    private static FluidEntry f(class_3611 fluid, int amount) {
        return new FluidEntry(fluid, amount);
    }

    private record FluidEntry(class_3611 fluid, int amount) {
    }

    private static enum PolymerizationKind {
        LEAD("lead", 4, 300),
        CHROMIUM("chromium", 1, 700);

        private final String catalystMaterial;
        private final int inputTinyDust;
        private final int outputMillis;

        private PolymerizationKind(String catalystMaterial, int inputTinyDust, int outputMillis) {
            this.catalystMaterial = catalystMaterial;
            this.inputTinyDust = inputTinyDust;
            this.outputMillis = outputMillis;
        }
    }
}

