/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.datagen.texture;

import aztech.modern_industrialization.textures.MITextures;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_1011;
import net.minecraft.class_1064;
import net.minecraft.class_1065;
import net.minecraft.class_1066;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3304;

public class TexturesProvider
implements class_2405 {
    private final FabricDataGenerator dataGenerator;

    public TexturesProvider(FabricDataGenerator dataGenerator) {
        this.dataGenerator = dataGenerator;
    }

    public void method_10319(class_2408 cache) throws IOException {
        Path textureDir = this.dataGenerator.method_10313().resolve("assets/modern_industrialization/textures");
        if (Files.exists(textureDir, new LinkOption[0])) {
            try (Stream<Path> walk = Files.walk(textureDir, new FileVisitOption[0]);){
                walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
        Path generatedResources = this.dataGenerator.method_10313();
        Path nonGeneratedResources = this.dataGenerator.method_10313().resolve("../../main/resources");
        class_3304 manager = new class_3304(class_3264.field_14188);
        manager.method_14475((class_3262)new class_1065(class_1066.field_27772, new class_1064(new File(""), "")));
        manager.method_14475((class_3262)new class_3259(nonGeneratedResources.toFile()));
        manager.method_14475((class_3262)new class_3259(generatedResources.toFile()));
        MITextures.offerTextures((image, textureId) -> this.writeTexture(cache, (class_1011)image, (String)textureId), (class_3300)manager);
    }

    private void writeTexture(class_2408 cache, class_1011 image, String textureId) {
        try {
            Path path = this.dataGenerator.method_10313().resolve("assets").resolve(textureId.replace(':', '/'));
            String sha = field_11280.hashBytes(image.method_24036()).toString();
            if (!Objects.equals(cache.method_10323(path), sha) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                image.method_4314(path);
            }
            cache.method_10325(path, sha);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write texture " + textureId, ex);
        }
    }

    public String method_10321() {
        return "Machine Textures Provider";
    }
}

