/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.items.diesel_tools;

import aztech.modern_industrialization.api.DynamicEnchantmentItem;
import aztech.modern_industrialization.api.FluidFuelRegistry;
import aztech.modern_industrialization.fluid.CraftingFluid;
import aztech.modern_industrialization.items.FluidFuelItemHelper;
import aztech.modern_industrialization.items.ItemHelper;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.tool.attribute.v1.DynamicAttributeTool;
import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1821;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_5150;
import org.jetbrains.annotations.Nullable;

public class DieselToolItem
extends class_1792
implements DynamicAttributeTool,
class_5150,
DynamicEnchantmentItem {
    public static final int CAPACITY = 324000;
    private final double damage;

    public DieselToolItem(class_1792.class_1793 settings, double damage) {
        super(settings.method_7889(1).method_7894(class_1814.field_8907));
        this.damage = damage;
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
        if (state.method_26214((class_1922)world, pos) != 0.0f) {
            FluidFuelItemHelper.decrement(stack);
        }
        return true;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        FluidFuelItemHelper.decrement(stack);
        return true;
    }

    public float getMiningSpeedMultiplier(class_3494<class_1792> tag, class_2680 state, class_1799 stack, @Nullable class_1309 user) {
        if (tag.method_15141((Object)this)) {
            return this.getMiningSpeedMultiplier(stack);
        }
        return 0.0f;
    }

    public int getMiningLevel(class_3494<class_1792> tag, class_2680 state, class_1799 stack, @Nullable class_1309 user) {
        if (tag.method_15141((Object)this) && FluidFuelItemHelper.getAmount(stack) > 0L) {
            return 4;
        }
        return 0;
    }

    private float getMiningSpeedMultiplier(class_1799 stack) {
        FluidVariant fluid;
        int burnTicks;
        long amount = FluidFuelItemHelper.getAmount(stack);
        if (amount > 0L && (burnTicks = FluidFuelRegistry.getEu((fluid = FluidFuelItemHelper.getFluid(stack)).getFluid())) > 0) {
            return 1.0f + (float)burnTicks / 4.0f;
        }
        return 1.0f;
    }

    public Multimap<class_1320, class_1322> getDynamicModifiers(class_1304 slot, class_1799 stack, @Nullable class_1309 user) {
        if (slot == class_1304.field_6173 && FluidFuelItemHelper.getAmount(stack) > 0L) {
            return ItemHelper.createToolModifiers(this.damage * (double)FluidFuelRegistry.getEu(FluidFuelItemHelper.getFluid(stack).getFluid()) / 300.0);
        }
        return EMPTY;
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        FluidFuelItemHelper.appendTooltip(stack, tooltip, 324000L);
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        return (int)Math.round(this.getDurabilityBarProgress(stack) * 13.0);
    }

    public int method_31571(class_1799 stack) {
        class_3611 fluid = FluidFuelItemHelper.getFluid(stack).getFluid();
        if (fluid instanceof CraftingFluid) {
            CraftingFluid cf = (CraftingFluid)fluid;
            return cf.color;
        }
        return 0;
    }

    public double getDurabilityBarProgress(class_1799 stack) {
        return (double)FluidFuelItemHelper.getAmount(stack) / 324000.0;
    }

    private static boolean isFortune(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10577("fortune");
    }

    private static void setFortune(class_1799 stack, boolean fortune) {
        if (fortune) {
            stack.method_7948().method_10556("fortune", true);
        } else {
            stack.method_7983("fortune");
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (hand == class_1268.field_5808 && user.method_5715()) {
            class_1799 stack;
            DieselToolItem.setFortune(stack, !DieselToolItem.isFortune(stack = user.method_5998(hand)));
            if (!world.field_9236) {
                user.method_7353((class_2561)new class_2588("text.modern_industrialization.tool_switched_" + (DieselToolItem.isFortune(stack) ? "fortune" : "silk_touch")), false);
            }
            return class_1271.method_29237((Object)stack, (boolean)world.field_9236);
        }
        return super.method_7836(world, user, hand);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1799 stack = context.method_8041();
        class_1937 w = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2680 state = w.method_8320(pos);
        class_1657 player = context.method_8036();
        if (FluidFuelItemHelper.getAmount(stack) > 0L) {
            class_2680 newState;
            if (FabricToolTags.AXES.method_15141((Object)this)) {
                class_2248 newBlock = StrippingAccess.getStrippedBlocks().get(state.method_26204());
                if (newBlock != null) {
                    w.method_8396(player, pos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
                    if (!w.field_9236) {
                        w.method_8652(pos, (class_2680)newBlock.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)state.method_11654((class_2769)class_2465.field_11459))), 11);
                        FluidFuelItemHelper.decrement(stack);
                    }
                    return class_1269.method_29236((boolean)w.field_9236);
                }
            } else if (FabricToolTags.SHOVELS.method_15141((Object)this) && (newState = PathingAccess.getPathStates().get(state.method_26204())) != null) {
                w.method_8396(player, pos, class_3417.field_14616, class_3419.field_15245, 1.0f, 1.0f);
                if (!w.field_9236) {
                    w.method_8652(pos, newState, 11);
                    FluidFuelItemHelper.decrement(stack);
                }
                return class_1269.method_29236((boolean)w.field_9236);
            }
        }
        return super.method_7884(context);
    }

    @Override
    public Reference2IntMap<class_1887> getEnchantments(class_1799 stack) {
        Reference2IntArrayMap map = new Reference2IntArrayMap();
        if (FluidFuelItemHelper.getAmount(stack) > 0L) {
            if (!DieselToolItem.isFortune(stack)) {
                map.put((Object)class_1893.field_9099, class_1893.field_9099.method_8183());
            } else {
                map.put((Object)class_1893.field_9130, class_1893.field_9130.method_8183());
            }
        }
        return map;
    }

    private static class StrippingAccess
    extends class_1743 {
        private StrippingAccess(class_1832 material, float attackDamage, float attackSpeed, class_1792.class_1793 settings) {
            super(material, attackDamage, attackSpeed, settings);
        }

        public static Map<class_2248, class_2248> getStrippedBlocks() {
            return field_7898;
        }
    }

    private static class PathingAccess
    extends class_1821 {
        private PathingAccess(class_1832 material, float attackDamage, float attackSpeed, class_1792.class_1793 settings) {
            super(material, attackDamage, attackSpeed, settings);
        }

        public static Map<class_2248, class_2680> getPathStates() {
            return field_8912;
        }
    }
}

