/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines;

import aztech.modern_industrialization.api.FastBlockEntity;
import aztech.modern_industrialization.api.WrenchableBlockEntity;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineOverlay;
import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.SyncedComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.NbtHelper;
import aztech.modern_industrialization.util.RenderHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public abstract class MachineBlockEntity
extends FastBlockEntity
implements ExtendedScreenHandlerFactory,
RenderAttachmentBlockEntity,
WrenchableBlockEntity {
    final List<SyncedComponent.Server> syncedComponents = new ArrayList<SyncedComponent.Server>();
    private final List<IComponent> icomponents = new ArrayList<IComponent>();
    private final MachineGuiParameters guiParams;
    private boolean syncCausesRemesh = true;
    protected final OrientationComponent orientation;

    public MachineBlockEntity(BEP bep, MachineGuiParameters guiParams, OrientationComponent.Params orientationParams) {
        super(bep.type(), bep.pos(), bep.state());
        this.guiParams = guiParams;
        this.orientation = new OrientationComponent(orientationParams);
        this.registerComponents(this.orientation);
    }

    protected final void registerClientComponent(SyncedComponent.Server component) {
        this.syncedComponents.add(component);
    }

    protected final void registerComponents(IComponent ... components) {
        Collections.addAll(this.icomponents, components);
    }

    public abstract MIInventory getInventory();

    public <S extends SyncedComponent.Server> S getComponent(class_2960 componentId) {
        for (SyncedComponent.Server component : this.syncedComponents) {
            if (!component.getId().equals((Object)componentId)) continue;
            return (S)component;
        }
        throw new RuntimeException("Couldn't find component " + componentId);
    }

    public final class_2561 method_5476() {
        return new class_2588("block.modern_industrialization." + this.guiParams.blockId);
    }

    public final class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new MachineScreenHandlers.Server(syncId, inv, this, this.guiParams);
    }

    public final void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        MIInventory inv = this.getInventory();
        buf.writeInt(inv.getItemStacks().size());
        buf.writeInt(inv.getFluidStacks().size());
        class_2487 tag = new class_2487();
        NbtHelper.putList(tag, "items", inv.getItemStacks(), ConfigurableItemStack::toNbt);
        NbtHelper.putList(tag, "fluids", inv.getFluidStacks(), ConfigurableFluidStack::toNbt);
        buf.method_10794(tag);
        inv.itemPositions.write(buf);
        inv.fluidPositions.write(buf);
        buf.writeInt(this.syncedComponents.size());
        for (SyncedComponent.Server component : this.syncedComponents) {
            buf.method_10812(component.getId());
            component.writeInitialData(buf);
        }
        this.guiParams.write(buf);
    }

    protected class_1269 onUse(class_1657 player, class_1268 hand, class_2350 face) {
        return class_1269.field_5811;
    }

    protected abstract MachineModelClientData getModelData();

    public abstract void onPlaced(class_1309 var1, class_1799 var2);

    @Override
    public boolean useWrench(class_1657 player, class_1268 hand, class_3965 hitResult) {
        if (this.orientation.useWrench(player, hand, MachineOverlay.findHitSide(hitResult))) {
            this.method_5431();
            if (!this.method_10997().method_8608()) {
                this.sync();
            }
            return true;
        }
        return false;
    }

    public final Object getRenderAttachmentData() {
        return this.getModelData();
    }

    @Override
    public void sync() {
        this.sync(true);
    }

    public void sync(boolean forceRemesh) {
        this.syncCausesRemesh = this.syncCausesRemesh || forceRemesh;
        super.sync();
    }

    public class_2487 method_16887() {
        class_2487 tag = new class_2487();
        tag.method_10556("remesh", this.syncCausesRemesh);
        this.syncCausesRemesh = false;
        for (IComponent component : this.icomponents) {
            component.writeClientNbt(tag);
        }
        return tag;
    }

    public final void method_11007(class_2487 tag) {
        for (IComponent component : this.icomponents) {
            component.writeNbt(tag);
        }
    }

    public final void method_11014(class_2487 tag) {
        if (!tag.method_10545("remesh")) {
            for (IComponent component : this.icomponents) {
                component.readNbt(tag);
            }
        } else {
            boolean forceChunkRemesh = tag.method_10577("remesh");
            for (IComponent component : this.icomponents) {
                component.readClientNbt(tag);
            }
            if (forceChunkRemesh) {
                RenderHelper.forceChunkRemesh(this.field_11863, this.field_11867);
            }
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public static void registerItemApi(class_2591<?> bet) {
        ItemStorage.SIDED.registerForBlockEntities((be, direction) -> ((MachineBlockEntity)be).getInventory().itemStorage, new class_2591[]{bet});
    }

    public static void registerFluidApi(class_2591<?> bet) {
        FluidStorage.SIDED.registerForBlockEntities((be, direction) -> ((MachineBlockEntity)be).getInventory().fluidStorage, new class_2591[]{bet});
    }

    public List<class_1799> dropExtra() {
        return new ArrayList<class_1799>();
    }
}

