/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.MachineInventoryComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.sync.AutoExtract;
import aztech.modern_industrialization.machines.components.sync.ProgressBar;
import aztech.modern_industrialization.machines.components.sync.ReiSlotLocking;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.init.MachineTier;
import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.util.Tickable;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public abstract class AbstractCraftingMachineBlockEntity
extends MachineBlockEntity
implements CrafterComponent.Behavior,
Tickable {
    private final MachineInventoryComponent inventory;
    protected final CrafterComponent crafter;
    private final MachineRecipeType type;
    protected final MachineTier tier;
    protected IsActiveComponent isActiveComponent;

    public AbstractCraftingMachineBlockEntity(BEP bep, MachineRecipeType recipeType, MachineInventoryComponent inventory, MachineGuiParameters guiParams, ProgressBar.Parameters progressBarParams, MachineTier tier) {
        super(bep, guiParams, new OrientationComponent.Params(true, inventory.itemOutputCount > 0, inventory.fluidOutputCount > 0));
        this.inventory = inventory;
        this.crafter = new CrafterComponent(inventory, this);
        this.type = recipeType;
        this.tier = tier;
        this.isActiveComponent = new IsActiveComponent();
        this.registerClientComponent(new AutoExtract.Server(this.orientation));
        this.registerClientComponent(new ProgressBar.Server(progressBarParams, this.crafter::getProgress));
        this.registerClientComponent(new ReiSlotLocking.Server(this.crafter::lockRecipe, () -> true));
        this.registerComponents(this.crafter, this.inventory, this.isActiveComponent);
    }

    @Override
    public MachineRecipeType recipeType() {
        return this.type;
    }

    @Override
    public long getBaseRecipeEu() {
        return this.tier.getBaseEu();
    }

    @Override
    public long getMaxRecipeEu() {
        return this.tier.getMaxEu();
    }

    @Override
    public void tick() {
        if (!this.field_11863.field_9236) {
            boolean newActive = this.crafter.tickRecipe();
            this.isActiveComponent.updateActive(newActive, this);
            if (this.orientation.extractItems) {
                this.inventory.inventory.autoExtractItems(this.field_11863, this.field_11867, this.orientation.outputDirection);
            }
            if (this.orientation.extractFluids) {
                this.inventory.inventory.autoExtractFluids(this.field_11863, this.field_11867, this.orientation.outputDirection);
            }
            this.method_5431();
        }
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory.inventory;
    }

    @Override
    public void onPlaced(class_1309 placer, class_1799 itemStack) {
        this.orientation.onPlaced(placer, itemStack);
    }

    @Override
    public class_1937 getCrafterWorld() {
        return this.field_11863;
    }
}

