/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.EnergyExtractable;
import aztech.modern_industrialization.api.energy.EnergyInsertable;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.sync.EnergyBar;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.helper.EnergyHelper;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Tickable;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2591;

public abstract class AbstractStorageMachineBlockEntity
extends MachineBlockEntity
implements Tickable {
    protected final EnergyComponent energy;
    protected final EnergyInsertable insertable;
    protected final EnergyExtractable extractable;
    protected final long eu_capacity;
    protected final CableTier from;
    protected final CableTier to;

    public AbstractStorageMachineBlockEntity(BEP bep, CableTier from, CableTier to, String name, long eu_capacity) {
        super(bep, new MachineGuiParameters.Builder(name, false).build(), new OrientationComponent.Params(true, false, false));
        this.from = from;
        this.to = to;
        this.eu_capacity = eu_capacity;
        this.energy = new EnergyComponent(eu_capacity);
        this.insertable = this.energy.buildInsertable(tier -> tier == from);
        this.extractable = this.energy.buildExtractable(tier -> tier == to);
        EnergyBar.Parameters energyBarParams = new EnergyBar.Parameters(76, 39);
        this.registerClientComponent(new EnergyBar.Server(energyBarParams, this.energy::getEu, this.energy::getCapacity));
        this.registerComponents(this.energy);
    }

    @Override
    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    public static MachineCasing getCasingFromTier(CableTier from, CableTier to) {
        return MachineCasings.casingFromCableTier(from.eu > to.eu ? from : to);
    }

    @Override
    protected MachineModelClientData getModelData() {
        MachineModelClientData data = new MachineModelClientData();
        this.orientation.writeModelData(data);
        return data;
    }

    @Override
    public void onPlaced(class_1309 placer, class_1799 itemStack) {
        this.orientation.onPlaced(placer, itemStack);
    }

    @Override
    public void tick() {
        EnergyHelper.autoOuput(this, this.orientation, this.to, this.energy);
    }

    public static void registerEnergyApi(class_2591<?> bet) {
        EnergyApi.MOVEABLE.registerForBlockEntities((be, direction) -> {
            AbstractStorageMachineBlockEntity abe = (AbstractStorageMachineBlockEntity)be;
            if (abe.orientation.outputDirection == direction) {
                return abe.extractable;
            }
            return abe.insertable;
        }, new class_2591[]{bet});
    }
}

