/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.IsActiveComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.sync.ProgressBar;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.util.Tickable;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public abstract class AbstractWaterPumpBlockEntity
extends MachineBlockEntity
implements Tickable {
    protected static final int OUTPUT_SLOT_X = 110;
    protected static final int OUTPUT_SLOT_Y = 30;
    private static final ProgressBar.Parameters PROGRESS_BAR = new ProgressBar.Parameters(79, 29, "extract");
    private static final int OPERATION_TICKS = 100;
    protected int pumpingTicks = 0;
    protected IsActiveComponent isActiveComponent = new IsActiveComponent();
    private static final int[] DX = new int[]{-1, 0, 1, 1, 1, 0, -1, -1};
    private static final int[] DZ = new int[]{-1, -1, -1, 0, 1, 1, 1, 0};

    public AbstractWaterPumpBlockEntity(BEP bep, String blockName) {
        super(bep, new MachineGuiParameters.Builder(blockName, false).build(), new OrientationComponent.Params(true, false, false));
        this.registerClientComponent(new ProgressBar.Server(PROGRESS_BAR, () -> Float.valueOf((float)this.pumpingTicks / 100.0f)));
        this.registerComponents(this.isActiveComponent, new IComponent(){

            @Override
            public void writeNbt(class_2487 tag) {
                tag.method_10569("pumpingTicks", AbstractWaterPumpBlockEntity.this.pumpingTicks);
            }

            @Override
            public void readNbt(class_2487 tag) {
                AbstractWaterPumpBlockEntity.this.pumpingTicks = tag.method_10550("pumpingTicks");
            }
        });
    }

    protected abstract long consumeEu(long var1);

    protected abstract int getWaterMultiplier();

    @Override
    public void onPlaced(class_1309 placer, class_1799 itemStack) {
        this.orientation.onPlaced(placer, itemStack);
    }

    @Override
    public void tick() {
        if (!this.field_11863.field_9236) {
            List<ConfigurableFluidStack> fluidStacks = this.getInventory().getFluidStacks();
            ConfigurableFluidStack waterStack = fluidStacks.get(fluidStacks.size() - 1);
            if (waterStack.getRemainingSpace() < 10125L) {
                this.updateActive(false);
            } else {
                long eu = this.consumeEu(1L);
                this.pumpingTicks = (int)((long)this.pumpingTicks + eu);
                this.updateActive(eu > 0L);
                if (this.pumpingTicks == 100) {
                    waterStack.setKey(FluidVariant.of((class_3611)class_3612.field_15910));
                    waterStack.increment(Math.min((long)this.getWaterMultiplier() * (long)this.getWaterSourceCount() * 81000L / 8L, waterStack.getRemainingSpace()));
                    this.pumpingTicks = 0;
                }
            }
            this.getInventory().autoExtractFluids(this.field_11863, this.field_11867, this.orientation.outputDirection);
            this.method_5431();
        }
    }

    private void updateActive(boolean newActive) {
        this.isActiveComponent.updateActive(newActive, this);
    }

    private int getWaterSourceCount() {
        boolean[] adjWater = new boolean[]{false, false, false, false, false, false, false, false};
        for (int i = 0; i < 8; ++i) {
            class_2338 adjPos = this.field_11867.method_10069(DX[i], 0, DZ[i]);
            class_3610 adjState = this.field_11863.method_8316(adjPos);
            if (!adjState.method_15771() || adjState.method_15772() != class_3612.field_15910) continue;
            adjWater[i] = true;
        }
        int count = 0;
        for (int i = 0; i < 8; ++i) {
            if (!adjWater[i] || i % 2 != 1 && !adjWater[(i + 7) % 8] && !adjWater[(i + 1) % 8]) continue;
            ++count;
        }
        return count;
    }
}

