/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.EnergyInsertable;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.blockentities.AbstractWaterPumpBlockEntity;
import aztech.modern_industrialization.machines.components.EnergyComponent;
import aztech.modern_industrialization.machines.components.sync.EnergyBar;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.util.Simulation;
import java.util.Collections;
import net.minecraft.class_2591;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class ElectricWaterPumpBlockEntity
extends AbstractWaterPumpBlockEntity {
    private final MIInventory inventory;
    private final EnergyComponent energy;
    private final EnergyInsertable insertable;

    public ElectricWaterPumpBlockEntity(BEP bep) {
        super(bep, "electric_water_pump");
        long capacity = 2592000L;
        this.inventory = new MIInventory(Collections.emptyList(), Collections.singletonList(ConfigurableFluidStack.lockedOutputSlot(capacity, (class_3611)class_3612.field_15910)), SlotPositions.empty(), new SlotPositions.Builder().addSlot(110, 30).build());
        this.energy = new EnergyComponent(3200L);
        this.insertable = this.energy.buildInsertable(tier -> tier == CableTier.LV);
        this.registerClientComponent(new EnergyBar.Server(new EnergyBar.Parameters(18, 32), this.energy::getEu, this.energy::getCapacity));
        this.registerComponents(this.energy);
        this.registerComponents(this.inventory);
    }

    @Override
    protected long consumeEu(long max) {
        return this.energy.consumeEu(max, Simulation.ACT);
    }

    @Override
    protected int getWaterMultiplier() {
        return 16;
    }

    @Override
    public MIInventory getInventory() {
        return this.inventory;
    }

    @Override
    protected MachineModelClientData getModelData() {
        MachineModelClientData data = new MachineModelClientData();
        data.isActive = this.isActiveComponent.isActive;
        this.orientation.writeModelData(data);
        return data;
    }

    public static void registerEnergyApi(class_2591<?> bet) {
        EnergyApi.MOVEABLE.registerForBlockEntities((be, direction) -> ((ElectricWaterPumpBlockEntity)be).insertable, new class_2591[]{bet});
    }
}

