/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.blockentities.multiblocks;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.components.DynamicShapeComponent;
import aztech.modern_industrialization.machines.components.FluidStorageComponent;
import aztech.modern_industrialization.machines.components.OrientationComponent;
import aztech.modern_industrialization.machines.components.sync.FluidGUIComponent;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModelClientData;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import aztech.modern_industrialization.util.Tickable;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;

public class LargeTankMultiblockBlockEntity
extends MultiblockMachineBlockEntity
implements Tickable,
DynamicShapeComponent.DynamicShapeComponentBlockEntity {
    private static final ShapeTemplate[] shapeTemplates = new ShapeTemplate[75];
    private final DynamicShapeComponent shapeComponent = new DynamicShapeComponent(shapeTemplates);
    private final FluidStorageComponent fluidStorage = new FluidStorageComponent();
    private FluidGUIComponent.Data oldFluidData;

    public static void registerFluidAPI(class_2591<?> bet) {
        FluidStorage.SIDED.registerForBlockEntities((be, direction) -> {
            LargeTankMultiblockBlockEntity tank = (LargeTankMultiblockBlockEntity)be;
            if (tank.isShapeValid()) {
                return tank.fluidStorage.getFluidStorage();
            }
            return Storage.empty();
        }, new class_2591[]{bet});
    }

    private static ShapeTemplate buildShape(int index) {
        int sizeX = 3 + 2 * (index / 25);
        int sizeY = 3 + index % 25 / 5;
        int sizeZ = 3 + index % 25 % 5;
        ShapeTemplate.Builder templateBuilder = new ShapeTemplate.Builder(MachineCasings.STEEL);
        SimpleMember steelCasing = SimpleMember.forBlock((class_2248)MIBlock.blocks.get("steel_machine_casing"));
        SimpleMember glass = SimpleMember.forBlock(class_2246.field_10033);
        HatchFlags hatchFlags = new HatchFlags.Builder().build();
        for (int x = -sizeX / 2; x <= sizeX / 2; ++x) {
            for (int y = -1; y < sizeY - 1; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    int lim = 0;
                    if (x == -sizeX / 2 || x == sizeX / 2) {
                        ++lim;
                    }
                    if (y == -1 || y == sizeY - 2) {
                        ++lim;
                    }
                    if (z == 0 || z == sizeZ - 1) {
                        ++lim;
                    }
                    if (x == 0 && y == 0 && z == 0) continue;
                    if (lim == 1) {
                        templateBuilder.add(x, y, z, glass, hatchFlags);
                        continue;
                    }
                    if (lim < 2) continue;
                    templateBuilder.add(x, y, z, steelCasing, hatchFlags);
                }
            }
        }
        return templateBuilder.build();
    }

    public LargeTankMultiblockBlockEntity(BEP bep) {
        super(bep, new MachineGuiParameters.Builder("large_tank", false).build(), new OrientationComponent.Params(false, false, false));
        this.registerComponents(this.shapeComponent);
        this.registerComponents(this.fluidStorage);
        this.registerClientComponent(new FluidGUIComponent.Server(this::getFluidData));
    }

    public FluidGUIComponent.Data getFluidData() {
        return new FluidGUIComponent.Data(this.fluidStorage.getFluid(), this.fluidStorage.getAmount(), this.fluidStorage.getCapacity());
    }

    @Override
    public MIInventory getInventory() {
        return MIInventory.EMPTY;
    }

    @Override
    public ShapeTemplate getActiveShape() {
        return this.shapeComponent.getActiveShape();
    }

    @Override
    protected MachineModelClientData getModelData() {
        return new MachineModelClientData(null, this.orientation.facingDirection);
    }

    @Override
    public void onPlaced(class_1309 placer, class_1799 itemStack) {
        this.orientation.onPlaced(placer, itemStack);
    }

    protected final void link() {
        this.shapeComponent.link(this);
    }

    @Override
    protected final void unlink() {
        this.shapeComponent.unlink(this);
    }

    @Override
    public void tick() {
        if (!this.field_11863.field_9236) {
            this.link();
            this.method_5431();
            if (!this.getFluidData().equals(this.oldFluidData)) {
                this.oldFluidData = this.getFluidData();
                this.sync(false);
            }
        }
    }

    @Override
    public MultiblockMachineBlockEntity getMultiblockMachineBlockEntity() {
        return this;
    }

    @Override
    public void onMatchSuccessful() {
        int index = this.shapeComponent.getActiveShapeIndex();
        int sizeX = 3 + 2 * (index / 25);
        int sizeY = 3 + index % 25 / 5;
        int sizeZ = 3 + index % 25 % 5;
        int volume = sizeX * sizeY * sizeZ;
        long capacity = (long)volume * 64L * 81000L;
        this.fluidStorage.setCapacity(capacity);
    }

    public FluidVariant getFluid() {
        return this.fluidStorage.getFluid();
    }

    public double getFullnessFraction() {
        return (double)this.fluidStorage.getAmount() / (double)this.fluidStorage.getCapacity();
    }

    public int[] getCornerPosition() {
        int i;
        int index = this.shapeComponent.getActiveShapeIndex();
        int sizeX = 3 + 2 * (index / 25);
        int sizeY = 3 + index % 25 / 5;
        int sizeZ = 3 + index % 25 % 5;
        class_2338[] corners = new class_2338[]{ShapeMatcher.toWorldPos(this.method_11016(), this.orientation.facingDirection, new class_2338(-sizeX / 2 + 1, 0, 1)), ShapeMatcher.toWorldPos(this.method_11016(), this.orientation.facingDirection, new class_2338(sizeX / 2 - 1, sizeY - 3, sizeZ - 2))};
        int[] cornerPosition = new int[6];
        for (i = 0; i < 3; ++i) {
            cornerPosition[i] = Integer.MIN_VALUE;
            cornerPosition[i + 3] = Integer.MAX_VALUE;
        }
        for (i = 0; i < 2; ++i) {
            cornerPosition[0] = Math.max(corners[i].method_10263() - this.method_11016().method_10263(), cornerPosition[0]);
            cornerPosition[1] = Math.max(corners[i].method_10264() - this.method_11016().method_10264(), cornerPosition[1]);
            cornerPosition[2] = Math.max(corners[i].method_10260() - this.method_11016().method_10260(), cornerPosition[2]);
            cornerPosition[3] = Math.min(corners[i].method_10263() - this.method_11016().method_10263(), cornerPosition[3]);
            cornerPosition[4] = Math.min(corners[i].method_10264() - this.method_11016().method_10264(), cornerPosition[4]);
            cornerPosition[5] = Math.min(corners[i].method_10260() - this.method_11016().method_10260(), cornerPosition[5]);
        }
        return cornerPosition;
    }

    static {
        for (int i = 0; i < shapeTemplates.length; ++i) {
            LargeTankMultiblockBlockEntity.shapeTemplates[i] = LargeTankMultiblockBlockEntity.buildShape(i);
        }
    }
}

