/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.ShapeMatcher;
import aztech.modern_industrialization.machines.multiblocks.ShapeTemplate;
import net.minecraft.class_1937;
import net.minecraft.class_2487;

public class DynamicShapeComponent
implements IComponent {
    public final ShapeTemplate[] shapeTemplates;
    private int activeShape = 0;
    private ShapeMatcher shapeMatcher;
    private ShapeMatcher unionShapeMatcher;

    public DynamicShapeComponent(ShapeTemplate[] shapeTemplates) {
        this.shapeTemplates = shapeTemplates;
    }

    public int getActiveShapeIndex() {
        return this.activeShape;
    }

    @Override
    public void writeNbt(class_2487 tag) {
        tag.method_10569("activeShape", this.activeShape);
    }

    @Override
    public void readNbt(class_2487 tag) {
        this.activeShape = tag.method_10550("activeShape");
    }

    public ShapeTemplate getActiveShape() {
        return this.shapeTemplates[this.activeShape];
    }

    public void link(DynamicShapeComponentBlockEntity dynamicShapeBlockEntity) {
        ShapeMatcher currentShapeMatcher;
        MultiblockMachineBlockEntity blockEntity = dynamicShapeBlockEntity.getMultiblockMachineBlockEntity();
        if (this.unionShapeMatcher == null) {
            this.unionShapeMatcher = new ShapeMatcher(blockEntity.method_10997(), blockEntity.method_11016(), blockEntity.getOrientation().facingDirection, ShapeTemplate.computeDummyUnion(this.shapeTemplates));
            this.unionShapeMatcher.registerListeners(blockEntity.method_10997());
        }
        ShapeMatcher oldShapeMatcher = currentShapeMatcher = this.shapeMatcher;
        for (int j = 0; j < this.shapeTemplates.length; ++j) {
            int shapeIndex = (this.activeShape + j) % this.shapeTemplates.length;
            ShapeTemplate currentShapeAttempt = this.shapeTemplates[shapeIndex];
            if (j != 0 || currentShapeMatcher == null) {
                currentShapeMatcher = new ShapeMatcher(blockEntity.method_10997(), blockEntity.method_11016(), blockEntity.getOrientation().facingDirection, currentShapeAttempt);
            }
            if (currentShapeMatcher.needsRematch() || this.unionShapeMatcher.needsRematch()) {
                blockEntity.shapeValid.shapeValid = false;
                currentShapeMatcher.rematch(blockEntity.method_10997());
                if (currentShapeMatcher.isMatchSuccessful()) {
                    if (currentShapeMatcher != oldShapeMatcher) {
                        this.unlink(dynamicShapeBlockEntity);
                        this.shapeMatcher = currentShapeMatcher;
                        currentShapeMatcher.registerListeners(blockEntity.method_10997());
                    }
                    blockEntity.shapeValid.shapeValid = true;
                    boolean sync = true;
                    if (this.activeShape != shapeIndex) {
                        sync = true;
                    }
                    this.activeShape = shapeIndex;
                    if (blockEntity.shapeValid.update()) {
                        sync = true;
                    }
                    if (sync) {
                        blockEntity.sync(false);
                    }
                    dynamicShapeBlockEntity.onMatchSuccessful();
                    return;
                }
                if (!blockEntity.shapeValid.update()) continue;
                blockEntity.sync(false);
                continue;
            }
            return;
        }
    }

    public void unlink(DynamicShapeComponentBlockEntity dynamicShapeBlockEntity) {
        class_1937 world = dynamicShapeBlockEntity.getMultiblockMachineBlockEntity().method_10997();
        if (this.shapeMatcher != null) {
            this.shapeMatcher.unlinkHatches();
            this.shapeMatcher.unregisterListeners(world);
            this.shapeMatcher = null;
        }
        if (this.unionShapeMatcher != null) {
            this.unionShapeMatcher.unregisterListeners(world);
            this.unionShapeMatcher = null;
        }
    }

    public static interface DynamicShapeComponentBlockEntity {
        public MultiblockMachineBlockEntity getMultiblockMachineBlockEntity();

        public void onMatchSuccessful();
    }
}

