/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.machines.IComponent;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2487;
import net.minecraft.class_3611;

public class FluidConsumerComponent
implements IComponent.ServerOnly {
    private long euBuffer = 0L;
    private final long maxEuProduction;
    private final Predicate<class_3611> acceptedFluid;
    private final ToLongFunction<class_3611> fluidEUperMb;

    public FluidConsumerComponent(long maxEuProduction, Predicate<class_3611> acceptedFluid, ToLongFunction<class_3611> fluidEUperMb) {
        this.maxEuProduction = maxEuProduction;
        this.acceptedFluid = acceptedFluid;
        this.fluidEUperMb = fluidEUperMb;
    }

    @Override
    public void writeNbt(class_2487 tag) {
        tag.method_10544("euBuffer", this.euBuffer);
    }

    @Override
    public void readNbt(class_2487 tag) {
        this.euBuffer = tag.method_10537("euBuffer");
    }

    public long getEuProduction(List<ConfigurableFluidStack> fluidInputs, long maxEnergyInsertable) {
        long maxEuProduced = Math.min(maxEnergyInsertable, this.maxEuProduction);
        if (maxEuProduced == 0L) {
            return 0L;
        }
        if (this.euBuffer >= maxEuProduced) {
            this.euBuffer -= maxEuProduced;
            return maxEuProduced;
        }
        long euProduced = 0L;
        for (ConfigurableFluidStack stack : fluidInputs) {
            class_3611 fluid = ((FluidVariant)stack.getResource()).getFluid();
            if (!this.acceptedFluid.test(fluid) || stack.getAmount() < 81L) continue;
            long fuelEu = this.fluidEUperMb.applyAsLong(fluid);
            long mbConsumedMax = Math.min((maxEuProduced - euProduced + fuelEu - 1L) / fuelEu, stack.getAmount() / 81L);
            stack.decrement(mbConsumedMax * 81L);
            if ((euProduced += mbConsumedMax * fuelEu) < maxEuProduced) continue;
            this.euBuffer += euProduced - maxEuProduced;
            return maxEuProduced;
        }
        return euProduced;
    }
}

