/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.components.CrafterComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;

public class MachineInventoryComponent
implements CrafterComponent.Inventory,
IComponent.ServerOnly {
    public final int itemInputCount;
    public final int itemOutputCount;
    public final int fluidInputCount;
    public final int fluidOutputCount;
    public final MIInventory inventory;

    public MachineInventoryComponent(List<ConfigurableItemStack> itemInputs, List<ConfigurableItemStack> itemOutputs, List<ConfigurableFluidStack> fluidInputs, List<ConfigurableFluidStack> fluidOutputs, SlotPositions itemPositions, SlotPositions fluidPositions) {
        this.itemInputCount = itemInputs.size();
        this.itemOutputCount = itemOutputs.size();
        this.fluidInputCount = fluidInputs.size();
        this.fluidOutputCount = fluidOutputs.size();
        ArrayList<ConfigurableItemStack> itemStacks = new ArrayList<ConfigurableItemStack>();
        itemStacks.addAll(itemInputs);
        itemStacks.addAll(itemOutputs);
        ArrayList<ConfigurableFluidStack> fluidStacks = new ArrayList<ConfigurableFluidStack>();
        fluidStacks.addAll(fluidInputs);
        fluidStacks.addAll(fluidOutputs);
        this.inventory = new MIInventory(itemStacks, fluidStacks, itemPositions, fluidPositions);
    }

    @Override
    public List<ConfigurableItemStack> getItemInputs() {
        return this.inventory.getItemStacks().subList(0, this.itemInputCount);
    }

    @Override
    public List<ConfigurableItemStack> getItemOutputs() {
        return this.inventory.getItemStacks().subList(this.itemInputCount, this.itemInputCount + this.itemOutputCount);
    }

    @Override
    public List<ConfigurableFluidStack> getFluidInputs() {
        return this.inventory.getFluidStacks().subList(0, this.fluidInputCount);
    }

    @Override
    public List<ConfigurableFluidStack> getFluidOutputs() {
        return this.inventory.getFluidStacks().subList(this.fluidInputCount, this.fluidInputCount + this.fluidOutputCount);
    }

    @Override
    public void writeNbt(class_2487 tag) {
        this.inventory.writeNbt(tag);
    }

    @Override
    public void readNbt(class_2487 tag) {
        this.inventory.readNbt(tag);
    }
}

