/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.MIFluidStorage;
import aztech.modern_industrialization.machines.components.TemperatureComponent;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class SteamHeaterComponent
extends TemperatureComponent {
    private static final int STEAM_TO_WATER = 16;
    public final long maxEuProduction;
    public final long euPerDegree;
    public final boolean acceptHighPressure;
    public final boolean acceptLowPressure;

    public SteamHeaterComponent(double temperatureMax, long maxEuProduction, long euPerDegree) {
        super(temperatureMax);
        this.maxEuProduction = maxEuProduction;
        this.euPerDegree = euPerDegree;
        this.acceptLowPressure = true;
        this.acceptHighPressure = false;
    }

    public SteamHeaterComponent(double temperatureMax, long maxEuProduction, long euPerDegree, boolean acceptLowPressure, boolean acceptHighPressure) {
        super(temperatureMax);
        this.maxEuProduction = maxEuProduction;
        this.euPerDegree = euPerDegree;
        this.acceptLowPressure = acceptLowPressure;
        this.acceptHighPressure = acceptHighPressure;
    }

    public double tick(List<ConfigurableFluidStack> fluidInputs, List<ConfigurableFluidStack> fluidOutputs) {
        double euProducedLowPressure = 0.0;
        if (this.acceptLowPressure && (euProducedLowPressure = this.tryMakeSteam(fluidInputs, fluidOutputs, (class_3611)class_3612.field_15910, (class_3611)MIFluids.STEAM, 1)) == 0.0) {
            euProducedLowPressure = this.tryMakeSteam(fluidInputs, fluidOutputs, (class_3611)MIFluids.HEAVY_WATER, (class_3611)MIFluids.HEAVY_WATER_STEAM, 1);
        }
        double euProducedHighPressure = 0.0;
        if (this.acceptHighPressure && (euProducedHighPressure = this.tryMakeSteam(fluidInputs, fluidOutputs, (class_3611)MIFluids.HIGH_PRESSURE_WATER, (class_3611)MIFluids.HIGH_PRESSURE_STEAM, 8)) == 0.0) {
            euProducedHighPressure = this.tryMakeSteam(fluidInputs, fluidOutputs, (class_3611)MIFluids.HIGH_PRESSURE_HEAVY_WATER, (class_3611)MIFluids.HIGH_PRESSURE_HEAVY_WATER_STEAM, 8);
        }
        return euProducedLowPressure + euProducedHighPressure;
    }

    private double tryMakeSteam(List<ConfigurableFluidStack> input, List<ConfigurableFluidStack> output, class_3611 water, class_3611 steam, int euPerSteamMb) {
        return this.tryMakeSteam(new MIFluidStorage(input), new MIFluidStorage(output), water, steam, euPerSteamMb);
    }

    private double tryMakeSteam(MIFluidStorage input, MIFluidStorage output, class_3611 water, class_3611 steam, int euPerSteamMb) {
        FluidVariant waterKey = FluidVariant.of((class_3611)water);
        FluidVariant steamKey = FluidVariant.of((class_3611)steam);
        if (this.getTemperature() > 100.0) {
            long steamProduction = (long)(81.0 * (this.getTemperature() - 100.0) / (this.temperatureMax - 100.0) * (double)this.maxEuProduction / (double)euPerSteamMb);
            try (Transaction tx = Transaction.openOuter();){
                long extracted;
                long inserted;
                try (Transaction simul = Transaction.openNested((TransactionContext)tx);){
                    inserted = output.insertAllSlot(steamKey, steamProduction, (TransactionContext)simul);
                }
                if (inserted > 0L && (extracted = input.extractAllSlot(waterKey, inserted / 16L, (TransactionContext)tx)) > 0L) {
                    if (output.insertAllSlot(steamKey, extracted * 16L, (TransactionContext)tx) == extracted * 16L) {
                        double euProduced = (double)(extracted * 16L * (long)euPerSteamMb) / 81.0;
                        this.decreaseTemperature(euProduced / (double)this.euPerDegree);
                        tx.commit();
                        double d = euProduced;
                        return d;
                    }
                    throw new IllegalStateException("Steam Component : Logic bug: failed to insert");
                }
            }
        }
        return 0.0;
    }
}

