/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components.sync;

import aztech.modern_industrialization.machines.MachineScreenHandlers;
import aztech.modern_industrialization.machines.SyncedComponent;
import aztech.modern_industrialization.machines.SyncedComponents;
import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.util.RenderHelper;
import aztech.modern_industrialization.util.TextHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.class_2540;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class EnergyBar {

    public static class Parameters {
        public final int renderX;
        public final int renderY;

        public Parameters(int renderX, int renderY) {
            this.renderX = renderX;
            this.renderY = renderY;
        }
    }

    private static class Data {
        final long eu;
        final long maxEu;

        Data(long eu, long maxEu) {
            this.eu = eu;
            this.maxEu = maxEu;
        }
    }

    public static class Client
    implements SyncedComponent.Client {
        final Parameters params;
        long eu;
        long maxEu;

        public Client(class_2540 buf) {
            this.params = new Parameters(buf.readInt(), buf.readInt());
            this.read(buf);
        }

        @Override
        public void read(class_2540 buf) {
            this.eu = buf.readLong();
            this.maxEu = buf.readLong();
        }

        @Override
        public ClientComponentRenderer createRenderer() {
            return new Renderer();
        }

        public class Renderer
        implements ClientComponentRenderer {
            public static final int WIDTH = 13;
            public static final int HEIGHT = 18;

            public static void renderEnergy(class_332 helper, class_4587 matrices, int px, int py, float fill) {
                RenderSystem.setShaderTexture((int)0, (class_2960)MachineScreenHandlers.SLOT_ATLAS);
                helper.method_25302(matrices, px, py, 230, 0, 13, 18);
                int fillPixels = (int)((double)(fill * 18.0f) * 0.9 + 1.8);
                if ((double)fill > 0.95) {
                    fillPixels = 18;
                }
                helper.method_25302(matrices, px, py + 18 - fillPixels, 243, 18 - fillPixels, 13, fillPixels);
            }

            @Override
            public void renderBackground(class_332 helper, class_4587 matrices, int x, int y) {
                Renderer.renderEnergy(helper, matrices, x + Client.this.params.renderX, y + Client.this.params.renderY, (float)Client.this.eu / (float)Client.this.maxEu);
            }

            @Override
            public void renderTooltip(MachineScreenHandlers.ClientScreen screen, class_4587 matrices, int x, int y, int cursorX, int cursorY) {
                if (RenderHelper.isPointWithinRectangle(Client.this.params.renderX, Client.this.params.renderY, 13, 18, cursorX - x, cursorY - y)) {
                    class_2588 tooltip;
                    if (class_437.method_25442()) {
                        tooltip = new class_2588("text.modern_industrialization.energy_bar", new Object[]{Client.this.eu, Client.this.maxEu, ""});
                    } else {
                        TextHelper.MaxedAmount maxedAmount = TextHelper.getMaxedAmount(Client.this.eu, Client.this.maxEu);
                        tooltip = new class_2588("text.modern_industrialization.energy_bar", new Object[]{maxedAmount.digit(), maxedAmount.maxDigit(), maxedAmount.unit()});
                    }
                    screen.method_30901(matrices, Collections.singletonList(tooltip), cursorX, cursorY);
                }
            }
        }
    }

    public static class Server
    implements SyncedComponent.Server<Data> {
        public final Parameters params;
        public final Supplier<Long> euSupplier;
        public final Supplier<Long> maxEuSupplier;

        public Server(Parameters params, Supplier<Long> euSupplier, Supplier<Long> maxEuSupplier) {
            this.params = params;
            this.euSupplier = euSupplier;
            this.maxEuSupplier = maxEuSupplier;
        }

        @Override
        public Data copyData() {
            return new Data(this.euSupplier.get(), this.maxEuSupplier.get());
        }

        @Override
        public boolean needsSync(Data cachedData) {
            return cachedData.eu != this.euSupplier.get() || cachedData.maxEu != this.maxEuSupplier.get();
        }

        @Override
        public void writeInitialData(class_2540 buf) {
            buf.writeInt(this.params.renderX);
            buf.writeInt(this.params.renderY);
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(class_2540 buf) {
            buf.writeLong(this.euSupplier.get().longValue());
            buf.writeLong(this.maxEuSupplier.get().longValue());
        }

        @Override
        public class_2960 getId() {
            return SyncedComponents.ENERGY_BAR;
        }
    }
}

