/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.helper;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.util.Simulation;
import com.google.common.base.Preconditions;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;

public final class SteamHelper {
    public static long consumeSteamEu(List<ConfigurableFluidStack> fluidStacks, long maxEu, Simulation simulation) {
        Preconditions.checkArgument((maxEu >= 0L ? 1 : 0) != 0, (Object)"May not consume < 0 EU.");
        long totalRem = 0L;
        for (ConfigurableFluidStack stack : fluidStacks) {
            if (((FluidVariant)stack.getResource()).getFluid() != MIFluids.STEAM) continue;
            long amount = stack.getAmount();
            long rem = Math.min(maxEu, amount / 81L);
            if (simulation.isActing()) {
                stack.decrement(rem * 81L);
            }
            maxEu -= rem;
            totalRem += rem;
        }
        return totalRem;
    }

    private SteamHelper() {
    }
}

