/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.init;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.inventory.ConfigurableFluidStack;
import aztech.modern_industrialization.inventory.ConfigurableItemStack;
import aztech.modern_industrialization.inventory.MIInventory;
import aztech.modern_industrialization.inventory.SlotPositions;
import aztech.modern_industrialization.machines.BEP;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.hatches.EnergyHatch;
import aztech.modern_industrialization.machines.blockentities.hatches.FluidHatch;
import aztech.modern_industrialization.machines.blockentities.hatches.ItemHatch;
import aztech.modern_industrialization.machines.blockentities.hatches.NuclearHatch;
import aztech.modern_industrialization.machines.gui.MachineGuiParameters;
import aztech.modern_industrialization.machines.init.MachineRegistrationHelper;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineModels;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

public class MultiblockHatches {
    public static final int FLUID_HATCH_SLOT_X = 80;
    public static final int FLUID_HATCH_SLOT_Y = 40;

    public static void init() {
        MultiblockHatches.registerItemHatches("bronze", MachineCasings.BRONZE, 1, 1, 80, 40);
        MultiblockHatches.registerItemHatches("steel", MachineCasings.STEEL, 2, 1, 80, 30);
        MultiblockHatches.registerItemHatches("advanced", MachineCasings.MV, 2, 2, 71, 30);
        MultiblockHatches.registerItemHatches("turbo", MachineCasings.HV, 3, 3, 62, 21);
        MultiblockHatches.registerItemHatches("highly_advanced", MachineCasings.EV, 3, 5, 44, 18);
        MultiblockHatches.registerFluidHatches("bronze", MachineCasings.BRONZE, 4);
        MultiblockHatches.registerFluidHatches("steel", MachineCasings.STEEL, 8);
        MultiblockHatches.registerFluidHatches("advanced", MachineCasings.MV, 16);
        MultiblockHatches.registerFluidHatches("turbo", MachineCasings.HV, 32);
        MultiblockHatches.registerFluidHatches("highly_advanced", MachineCasings.EV, 64);
        MultiblockHatches.registerEnergyHatches(CableTier.LV);
        MultiblockHatches.registerEnergyHatches(CableTier.MV);
        MultiblockHatches.registerEnergyHatches(CableTier.HV);
        MultiblockHatches.registerEnergyHatches(CableTier.EV);
        MultiblockHatches.registerEnergyHatches(CableTier.SUPERCONDUCTOR);
        MachineRegistrationHelper.registerMachine("nuclear_item_hatch", bet -> new NuclearHatch((BEP)bet, false), NuclearHatch::registerItemApi);
        MachineRegistrationHelper.registerMachine("nuclear_fluid_hatch", bet -> new NuclearHatch((BEP)bet, true), NuclearHatch::registerFluidApi);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            MachineModels.addTieredMachine("nuclear_item_hatch", "hatch_nuclear", MachineCasings.NUCLEAR, false, true, false, false);
            MachineModels.addTieredMachine("nuclear_fluid_hatch", "hatch_nuclear", MachineCasings.NUCLEAR, false, true, false, false);
        }
    }

    private static void registerItemHatches(String prefix, MachineCasing casing, int rows, int columns, int xStart, int yStart) {
        for (int iter = 0; iter < 2; ++iter) {
            boolean input = iter == 0;
            String machine = prefix + "_item_" + (input ? "input" : "output") + "_hatch";
            MachineRegistrationHelper.registerMachine(machine, bet -> {
                ArrayList<ConfigurableItemStack> itemStacks = new ArrayList<ConfigurableItemStack>();
                for (int i = 0; i < rows * columns; ++i) {
                    if (input) {
                        itemStacks.add(ConfigurableItemStack.standardInputSlot());
                        continue;
                    }
                    itemStacks.add(ConfigurableItemStack.standardOutputSlot());
                }
                MIInventory inventory = new MIInventory(itemStacks, Collections.emptyList(), new SlotPositions.Builder().addSlots(xStart, yStart, rows, columns).build(), SlotPositions.empty());
                return new ItemHatch((BEP)bet, new MachineGuiParameters.Builder(machine, true).build(), input, !prefix.equals("bronze"), inventory);
            }, MachineBlockEntity::registerItemApi);
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) continue;
            MachineModels.addTieredMachine(machine, "hatch_item", casing, true, false, true, false);
        }
    }

    private static void registerFluidHatches(String prefix, MachineCasing casing, int bucketCapacity) {
        for (int iter = 0; iter < 2; ++iter) {
            boolean input = iter == 0;
            String machine = prefix + "_fluid_" + (input ? "input" : "output") + "_hatch";
            MachineRegistrationHelper.registerMachine(machine, bet -> {
                List<ConfigurableFluidStack> fluidStacks = Collections.singletonList(input ? ConfigurableFluidStack.standardInputSlot((long)bucketCapacity * 81000L) : ConfigurableFluidStack.standardOutputSlot((long)bucketCapacity * 81000L));
                MIInventory inventory = new MIInventory(Collections.emptyList(), fluidStacks, SlotPositions.empty(), new SlotPositions.Builder().addSlot(80, 40).build());
                return new FluidHatch((BEP)bet, new MachineGuiParameters.Builder(machine, true).build(), input, !prefix.equals("bronze"), inventory);
            }, MachineBlockEntity::registerFluidApi);
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) continue;
            MachineModels.addTieredMachine(machine, "hatch_fluid", casing, true, false, true, false);
        }
    }

    private static void registerEnergyHatches(CableTier tier) {
        for (int iter = 0; iter < 2; ++iter) {
            boolean input = iter == 0;
            String machine = tier.name + "_energy_" + (input ? "input" : "output") + "_hatch";
            MachineRegistrationHelper.registerMachine(machine, bet -> new EnergyHatch((BEP)bet, machine, input, tier), EnergyHatch::registerEnergyApi);
            if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) continue;
            MachineModels.addTieredMachine(machine, "hatch_energy", MachineCasings.casingFromCableTier(tier), true, false, true, false);
        }
    }
}

