/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.multiblocks;

import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.multiblocks.HatchFlags;
import aztech.modern_industrialization.machines.multiblocks.SimpleMember;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import org.jetbrains.annotations.Nullable;

public class ShapeTemplate {
    public final Map<class_2338, SimpleMember> simpleMembers = new HashMap<class_2338, SimpleMember>();
    public final Map<class_2338, HatchFlags> hatchFlags = new HashMap<class_2338, HatchFlags>();
    public final MachineCasing hatchCasing;

    public ShapeTemplate(MachineCasing hatchCasing) {
        this.hatchCasing = hatchCasing;
    }

    public static ShapeTemplate computeDummyUnion(ShapeTemplate[] templates) {
        Builder builder = new Builder(MachineCasings.BRICKS);
        for (ShapeTemplate template : templates) {
            for (class_2338 pos : template.simpleMembers.keySet()) {
                builder.add(pos.method_10263(), pos.method_10264(), pos.method_10260(), SimpleMember.forBlock(class_2246.field_16328), null);
            }
        }
        return builder.build();
    }

    public static class Builder {
        private final ShapeTemplate template;

        public Builder(MachineCasing hatchCasing) {
            this.template = new ShapeTemplate(hatchCasing);
        }

        public Builder add3by3Levels(int minY, int maxY, SimpleMember member, @Nullable HatchFlags flags) {
            for (int y = minY; y <= maxY; ++y) {
                this.add3by3(y, member, y != minY, y == minY || y == maxY ? flags : null);
            }
            return this;
        }

        public Builder add3by3LevelsRoofed(int minY, int maxY, SimpleMember member, @Nullable HatchFlags flags) {
            for (int y = minY; y <= maxY; ++y) {
                this.add3by3(y, member, y != minY && y != maxY, y == minY || y == maxY ? flags : null);
            }
            return this;
        }

        public Builder add(int x, int y, int z, SimpleMember member, @Nullable HatchFlags flags) {
            class_2338 pos = new class_2338(x, y, z);
            this.template.simpleMembers.put(pos, member);
            if (flags != null) {
                this.template.hatchFlags.put(pos, flags);
            }
            return this;
        }

        public Builder add(int x, int y, int z, SimpleMember member) {
            return this.add(x, y, z, member, null);
        }

        public Builder add3by3(int y, SimpleMember member, boolean hollow, @Nullable HatchFlags flags) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = 0; z <= 2; ++z) {
                    if (hollow && x == 0 && z == 1) continue;
                    this.add(x, y, z, member, flags);
                }
            }
            return this;
        }

        public Builder remove(int x, int y, int z) {
            class_2338 pos = new class_2338(x, y, z);
            this.template.simpleMembers.remove(pos);
            this.template.hatchFlags.remove(pos);
            return this;
        }

        public ShapeTemplate build() {
            this.remove(0, 0, 0);
            return this.template;
        }
    }
}

