/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.BuildablePart;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.MaterialPart;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.materials.part.RegularPart;
import aztech.modern_industrialization.textures.MITextures;
import net.minecraft.class_1011;

public class CasingPart
extends Part
implements BuildablePart {
    public CasingPart(String key) {
        super(key);
    }

    @Override
    public Part getPart() {
        return this;
    }

    public BuildablePart of(String path, float resistance) {
        RegularPart regPart = new RegularPart(this.key).asBlock(5.0f, resistance, 1).withTextureRegister((mtm, partContext, part, itemPath) -> {
            try {
                class_1011 image = MITextures.generateTexture(mtm, part.key, partContext.getMaterialSet(), partContext.getColoramp());
                if (part.equals(MIParts.MACHINE_CASING)) {
                    MITextures.casingFromTexture(mtm, partContext.getMaterialName(), image);
                    MITextures.tankFromTexture(mtm, partContext.getMaterialName(), image);
                } else {
                    MITextures.casingFromTexture(mtm, itemPath, image);
                }
                MITextures.appendTexture(mtm, image, itemPath, true);
                image.close();
            }
            catch (Throwable throwable) {
                MITextures.logTextureGenerationError(throwable, itemPath, partContext.getMaterialSet(), part.key);
            }
        });
        if (path != null) {
            return regPart.withCustomPath(path, path);
        }
        return regPart;
    }

    @Override
    public MaterialPart build(MaterialBuilder.PartContext ctx) {
        return this.of(null, 6.0f).build(ctx);
    }

    public BuildablePart of(String path) {
        return this.of(path, 6.0f);
    }

    public BuildablePart of(float resistance) {
        return this.of(null, resistance);
    }
}

