/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.materials.GemPart;
import aztech.modern_industrialization.materials.part.BarrelPart;
import aztech.modern_industrialization.materials.part.BlockPart;
import aztech.modern_industrialization.materials.part.BuildablePart;
import aztech.modern_industrialization.materials.part.CablePart;
import aztech.modern_industrialization.materials.part.CasingPart;
import aztech.modern_industrialization.materials.part.NuclearFuelPart;
import aztech.modern_industrialization.materials.part.OrePart;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.materials.part.RawMetalPart;
import aztech.modern_industrialization.materials.part.RegularPart;
import aztech.modern_industrialization.materials.part.TankPart;
import aztech.modern_industrialization.textures.MITextures;
import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.textures.coloramp.HotIngotColoramp;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1011;

public class MIParts {
    public static final RegularPart BATTERY = new RegularPart("battery");
    public static final BarrelPart BARREL = new BarrelPart();
    public static final RegularPart BLADE = new RegularPart("blade");
    public static final BlockPart BLOCK = new BlockPart();
    public static final RegularPart BOLT = new RegularPart("bolt");
    public static final CablePart CABLE = new CablePart();
    public static final RegularPart COIL = new RegularPart("coil").asColumnBlock();
    public static final RegularPart CRUSHED_DUST = new RegularPart("crushed_dust");
    public static final RegularPart CURVED_PLATE = new RegularPart("curved_plate");
    public static final RegularPart DOUBLE_INGOT = new RegularPart("double_ingot").withTextureRegister((mtm, partContext, part, itemPath) -> mtm.runAtEnd(() -> {
        try {
            MITextures.generateDoubleIngot(mtm, partContext.getMaterialName());
        }
        catch (Throwable throwable) {
            MITextures.logTextureGenerationError(throwable, partContext.getMaterialName(), partContext.getMaterialSet(), part.key);
        }
    }));
    public static final RegularPart DRILL_HEAD = new RegularPart("drill_head");
    public static final RegularPart DRILL = new RegularPart("drill").appendTextureRegister((mtm, partContext, part, itemPath) -> {
        String template = "modern_industrialization:textures/materialsets/common/drill.png";
        String templateOverlay = "modern_industrialization:textures/materialsets/common/mining_drill_overlay.png";
        String texturePath = String.format("modern_industrialization:textures/items/%s.png", partContext.getMaterialName() + "_mining_drill");
        try {
            class_1011 image = mtm.getAssetAsTexture(template);
            class_1011 overlay = mtm.getAssetAsTexture(templateOverlay);
            TextureHelper.colorize(image, partContext.getColoramp());
            mtm.addTexture(texturePath, TextureHelper.blend(image, overlay), true);
            image.close();
            overlay.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    });
    public static final RegularPart DUST = new RegularPart("dust");
    public static final RegularPart FINE_WIRE = new RegularPart("fine_wire");
    public static final RegularPart GEAR = new RegularPart("gear");
    public static final GemPart GEM = new GemPart();
    public static final RegularPart HAMMER = new RegularPart("hammer");
    public static final RegularPart HOT_INGOT = new RegularPart("hot_ingot").withTextureRegister((mtm, partContext, part, itemPath) -> MITextures.generateItemPartTexture(mtm, MIParts.INGOT.key, partContext.getMaterialSet(), itemPath, false, new HotIngotColoramp(partContext.getColoramp(), 0.1, 0.5)));
    public static final RegularPart INGOT = new RegularPart("ingot");
    public static final RegularPart LARGE_PLATE = new RegularPart("large_plate");
    public static final CasingPart MACHINE_CASING = new CasingPart("machine_casing");
    public static final CasingPart MACHINE_CASING_PIPE = new CasingPart("machine_casing_pipe");
    public static final CasingPart MACHINE_CASING_SPECIAL = new CasingPart("machine_casing_special");
    public static final RegularPart NUGGET = new RegularPart("nugget");
    public static final OrePart ORE = new OrePart(false);
    public static final OrePart ORE_DEEPLSATE = new OrePart(true);
    public static final RegularPart PLATE = new RegularPart("plate");
    public static final RawMetalPart RAW_METAL = new RawMetalPart(false);
    public static final RawMetalPart RAW_METAL_BLOCK = new RawMetalPart(true);
    public static final RegularPart RING = new RegularPart("ring");
    public static final RegularPart ROD = new RegularPart("rod");
    public static final RegularPart ROD_MAGNETIC = new RegularPart("rod_magnetic").withOverlay(ROD, "magnetic");
    public static final RegularPart ROTOR = new RegularPart("rotor");
    public static final TankPart TANK = new TankPart();
    public static final RegularPart TINY_DUST = new RegularPart("tiny_dust");
    public static final RegularPart WIRE = new RegularPart("wire");
    public static final RegularPart WIRE_MAGNETIC = new RegularPart("wire_magnetic").withOverlay(WIRE, "magnetic");
    public static final NuclearFuelPart FUEL_ROD = new NuclearFuelPart(NuclearFuelPart.Type.SIMPLE);
    public static final NuclearFuelPart FUEL_ROD_DEPLETED = new NuclearFuelPart(NuclearFuelPart.Type.DEPLETED);
    public static final NuclearFuelPart FUEL_ROD_DOUBLE = new NuclearFuelPart(NuclearFuelPart.Type.DOUBLE);
    public static final NuclearFuelPart FUEL_ROD_QUAD = new NuclearFuelPart(NuclearFuelPart.Type.QUAD);
    public static final RegularPart N_DOPED_PLATE = new RegularPart("n_doped_plate").withOverlay(PLATE, "n_doped");
    public static final RegularPart P_DOPED_PLATE = new RegularPart("p_doped_plate").withOverlay(PLATE, "p_doped");
    public static final BuildablePart[] ITEM_PURE_NON_METAL = new BuildablePart[]{TINY_DUST, DUST, CRUSHED_DUST};
    public static final BuildablePart[] ITEM_PURE_METAL = new BuildablePart[]{INGOT, NUGGET, TINY_DUST, DUST};
    public static final List<Part> TAGGED_PARTS_LIST = Arrays.asList(BLOCK, DUST, GEAR, INGOT, NUGGET, ORE, PLATE, TINY_DUST, RAW_METAL, RAW_METAL_BLOCK);
    public static final Set<Part> TAGGED_PARTS = new HashSet<Part>(TAGGED_PARTS_LIST);
    public static final Part[] BLOCKS = new Part[]{ORE, BARREL, BLOCK, COIL, MACHINE_CASING, MACHINE_CASING_SPECIAL, MACHINE_CASING_PIPE, RAW_METAL_BLOCK};

    public static String idOfPart(Part part, String materialName) {
        return "modern_industrialization:" + materialName + "_" + part.key;
    }
}

