/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.materials.part.BuildablePart;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.RegularPart;
import aztech.modern_industrialization.materials.part.UnbuildablePart;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.NuclearConstant;
import aztech.modern_industrialization.nuclear.NuclearFuel;
import aztech.modern_industrialization.textures.MITextures;
import aztech.modern_industrialization.textures.coloramp.ColorampDepleted;
import java.util.List;

public class NuclearFuelPart
extends UnbuildablePart<NuclearConstant.IsotopeFuelParams> {
    public final Type type;

    public NuclearFuelPart(Type type) {
        super(type.key);
        this.type = type;
    }

    public RegularPart of(NuclearConstant.IsotopeFuelParams params) {
        NuclearFuel.NuclearFuelParams fuelParams = new NuclearFuel.NuclearFuelParams(10240000 * this.type.size, params.maxTemp, params.tempLimitLow, params.tempLimitHigh, params.neutronsMultiplication, params.directEnergyFactor, this.type.size);
        INeutronBehaviour neutronBehaviour = INeutronBehaviour.of(NuclearConstant.ScatteringType.HEAVY, params, this.type.size);
        return new RegularPart(this.key).withRegister((registeringContext, partContext, part, itemPath, itemId, itemTag) -> {
            if (Type.DEPLETED == this.type) {
                MIItem.of(itemPath, 64);
            } else {
                NuclearFuel.of(itemPath, fuelParams, neutronBehaviour, partContext.getMaterialName() + "_fuel_rod_depleted");
            }
        }).withTextureRegister((mtm, partContext, part, itemPath) -> MITextures.generateItemPartTexture(mtm, this.type == Type.DEPLETED ? Type.SIMPLE.key : this.type.key, "common", itemPath, false, this.type == Type.DEPLETED ? new ColorampDepleted(partContext.getColoramp()) : partContext.getColoramp()));
    }

    public List<BuildablePart> ofAll(NuclearConstant.IsotopeFuelParams params) {
        return List.of(MIParts.FUEL_ROD.of(params), MIParts.FUEL_ROD_DOUBLE.of(params), MIParts.FUEL_ROD_QUAD.of(params), MIParts.FUEL_ROD_DEPLETED.of(params));
    }

    public static enum Type {
        DEPLETED(0, "fuel_rod_depleted"),
        SIMPLE(1, "fuel_rod"),
        DOUBLE(2, "fuel_rod_double"),
        QUAD(4, "fuel_rod_quad");

        public final int size;
        public final String key;

        private Type(int size, String key) {
            this.size = size;
            this.key = key;
        }
    }
}

