/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.part;

import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.ModernIndustrialization;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.MaterialHelper;
import aztech.modern_industrialization.materials.part.BuildablePart;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.MaterialPart;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.textures.MITextures;
import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.textures.TextureManager;
import java.io.IOException;
import net.devtech.arrp.json.tags.JTag;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.tool.attribute.v1.FabricToolTags;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3614;

public class RegularPart
extends Part
implements BuildablePart {
    private final Register register;
    private final Register clientRegister;
    private final TextureRegister textureRegister;

    public RegularPart(String key) {
        this(key, (registeringContext, partContext, part, itemPath, itemId, itemTag) -> {
            MIItem.of(itemPath);
            RegularPart.setupTag(part, itemId, itemTag);
        }, (registeringContext, partContext, part, itemPath, itemId, itemTag) -> {}, (mtm, partContext, part, itemPath) -> MITextures.generateItemPartTexture(mtm, part.key, partContext.getMaterialSet(), itemPath, false, partContext.getColoramp()));
    }

    private RegularPart(String key, Register register, Register clientRegister, TextureRegister textureRegister) {
        super(key);
        this.register = register;
        this.clientRegister = clientRegister;
        this.textureRegister = textureRegister;
    }

    private static void setupTag(Part part, String itemId, String itemTag) {
        for (Part partTagged : MIParts.TAGGED_PARTS) {
            if (!partTagged.equals(part)) continue;
            MaterialHelper.registerItemTag(itemTag.replaceFirst("#", ""), JTag.tag().add(new class_2960(itemId)));
        }
    }

    public RegularPart asBlock(float hardness, float resistance, int miningLevel) {
        return new RegularPart(this.key, (registeringContext, partContext, part, itemPath, itemId, itemTag) -> {
            new MIBlock(itemPath, FabricBlockSettings.of((class_3614)ModernIndustrialization.METAL_MATERIAL).breakByTool(FabricToolTags.PICKAXES, miningLevel).method_36557(hardness).method_36558(resistance).method_29292());
            RegularPart.setupTag(part, itemId, itemTag);
        }, this.clientRegister, (mtm, partContext, part, itemPath) -> MITextures.generateItemPartTexture(mtm, part.key, partContext.getMaterialSet(), itemPath, true, partContext.getColoramp()));
    }

    public RegularPart asColumnBlock() {
        return new RegularPart(this.key, (registeringContext, partContext, part, itemPath, itemId, itemTag) -> {
            MIBlock block = new MIBlock(itemPath, FabricBlockSettings.of((class_3614)ModernIndustrialization.METAL_MATERIAL).breakByTool(FabricToolTags.PICKAXES, 0).method_36557(5.0f).method_36558(6.0f).method_29292());
            block.asColumn();
        }, this.clientRegister, (mtm, partContext, part, itemPath) -> {
            for (String suffix : new String[]{"_end", "_side"}) {
                String template = String.format("modern_industrialization:textures/materialsets/common/%s%s.png", part, suffix);
                try {
                    class_1011 image = mtm.getAssetAsTexture(template);
                    TextureHelper.colorize(image, partContext.getColoramp());
                    String texturePath = String.format("modern_industrialization:textures/blocks/%s%s.png", itemPath, suffix);
                    mtm.addTexture(texturePath, image);
                    image.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public RegularPart withoutTextureRegister() {
        return this.withTextureRegister((mtm, partContext, part, itemPath) -> {});
    }

    public RegularPart asBlock() {
        return this.asBlock(5.0f, 6.0f, 0);
    }

    public RegularPart withRegister(Register register) {
        return new RegularPart(this.key, register, this.clientRegister, this.textureRegister);
    }

    public RegularPart withClientRegister(Register clientRegister) {
        return new RegularPart(this.key, this.register, clientRegister, this.textureRegister);
    }

    public RegularPart withTextureRegister(TextureRegister textureRegister) {
        return new RegularPart(this.key, this.register, this.clientRegister, textureRegister);
    }

    public RegularPart appendRegister(Register register) {
        return new RegularPart(this.key, (registeringContext, partContext, part, itemPath, itemId, itemTag) -> {
            this.register.register(registeringContext, partContext, part, itemPath, itemId, itemTag);
            register.register(registeringContext, partContext, part, itemPath, itemId, itemTag);
        }, this.clientRegister, this.textureRegister);
    }

    public RegularPart appendTextureRegister(TextureRegister textureRegister) {
        return new RegularPart(this.key, this.register, this.clientRegister, (mtm, partContext, part, itemPath) -> {
            this.textureRegister.register(mtm, partContext, part, itemPath);
            textureRegister.register(mtm, partContext, part, itemPath);
        });
    }

    public RegularPart withOverlay(Part normal, String overlay) {
        return this.withTextureRegister((mtm, partContext, part, itemPath) -> MITextures.generateItemPartTexture(mtm, normal.key, overlay, partContext.getMaterialSet(), itemPath, false, partContext.getColoramp()));
    }

    private static MaterialPart build(final String itemPath, final String itemId, final String itemTag, final MaterialBuilder.PartContext partContext, final Part part, final Register register, final Register clientRegister, final TextureRegister textureRegister) {
        return new MaterialPart(){

            @Override
            public Part getPart() {
                return part;
            }

            @Override
            public String getTaggedItemId() {
                return itemTag;
            }

            @Override
            public String getItemId() {
                return itemId;
            }

            @Override
            public void register(MaterialBuilder.RegisteringContext registeringContext) {
                register.register(registeringContext, partContext, part, itemPath, itemId, itemTag);
            }

            @Override
            public void registerClient() {
                clientRegister.register(null, partContext, part, itemPath, itemId, itemTag);
            }

            @Override
            public void registerTextures(TextureManager mtm) {
                textureRegister.register(mtm, partContext, part, itemPath);
            }
        };
    }

    public static String idFromPath(String path) {
        return "modern_industrialization:" + path;
    }

    @Override
    public MaterialPart build(MaterialBuilder.PartContext ctx) {
        String itemPath = ctx.getMaterialName() + "_" + this.key;
        String itemId = RegularPart.idFromPath(itemPath);
        Object itemTag = MIParts.TAGGED_PARTS.contains(this) ? "#c:" + ctx.getMaterialName() + "_" + this.key + "s" : itemId;
        return RegularPart.build(itemPath, itemId, (String)itemTag, ctx, this, this.register, this.clientRegister, this.textureRegister);
    }

    @Override
    public Part getPart() {
        return this;
    }

    public BuildablePart withCustomPath(String itemPath, String itemTag) {
        return BuildablePart.of(this, ctx -> RegularPart.build(itemPath, RegularPart.idFromPath(itemPath), itemTag, ctx, this, this.register, this.clientRegister, this.textureRegister));
    }

    public BuildablePart withCustomPath(String itemPath) {
        return this.withCustomPath(itemPath, itemPath);
    }

    public BuildablePart withCustomFormattablePath(String itemPath, String itemTag) {
        return BuildablePart.of(this, ctx -> {
            String path = String.format(itemPath, ctx.getMaterialName());
            String tag = "#c:" + String.format(itemTag, ctx.getMaterialName());
            return RegularPart.build(path, RegularPart.idFromPath(path), tag, ctx, this, this.register, this.clientRegister, this.textureRegister);
        });
    }

    public BuildablePart withCustomFormattablePath(String itemPath) {
        return this.withCustomFormattablePath(itemPath, itemPath);
    }

    @FunctionalInterface
    public static interface Register {
        public void register(MaterialBuilder.RegisteringContext var1, MaterialBuilder.PartContext var2, Part var3, String var4, String var5, String var6);
    }

    @FunctionalInterface
    public static interface TextureRegister {
        public void register(TextureManager var1, MaterialBuilder.PartContext var2, Part var3, String var4);
    }
}

