/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.recipe;

import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.machines.init.MIMachineRecipeTypes;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.materials.recipe.builder.MIRecipeBuilder;
import aztech.modern_industrialization.materials.recipe.builder.ShapedRecipeBuilder;
import aztech.modern_industrialization.materials.recipe.builder.SmeltingRecipeBuilder;

public final class StandardRecipes {
    public static void apply(MaterialBuilder.RecipeContext ctx) {
        StandardRecipes.add3By3Crafting(ctx, MIParts.TINY_DUST, MIParts.DUST, true);
        StandardRecipes.add3By3Crafting(ctx, MIParts.NUGGET, MIParts.INGOT, true);
        StandardRecipes.add3By3Crafting(ctx, ctx.getMainPart(), MIParts.BLOCK, false);
        StandardRecipes.add3By3Crafting(ctx, MIParts.RAW_METAL, MIParts.RAW_METAL_BLOCK, true);
        new ShapedRecipeBuilder(ctx, MIParts.BLADE, 4, "blade", "P", "P", "I").addTaggedPart('P', MIParts.CURVED_PLATE).addTaggedPart('I', MIParts.ROD).exportToMachine(MIMachineRecipeTypes.PACKER);
        new ShapedRecipeBuilder(ctx, MIParts.ORE, 1, "deeplsate_to_ore", "   ", " x ", "   ").addPart('x', MIParts.ORE_DEEPLSATE);
        new ShapedRecipeBuilder(ctx, MIParts.COIL, 1, "coil", "xxx", "x x", "xxx").addTaggedPart('x', MIParts.CABLE).exportToAssembler();
        new ShapedRecipeBuilder(ctx, MIParts.LARGE_PLATE, 1, "large_plate", "xx", "xx").addTaggedPart('x', MIParts.PLATE).exportToMachine(MIMachineRecipeTypes.PACKER);
        new ShapedRecipeBuilder(ctx, MIParts.ROTOR, 1, "rotor", "bBb", "BRB", "bBb").addTaggedPart('b', MIParts.BOLT).addTaggedPart('B', MIParts.BLADE).addTaggedPart('R', MIParts.RING);
        new ShapedRecipeBuilder(ctx, MIParts.GEAR, 1, "gear", "PbP", "bRb", "PbP").addTaggedPart('b', MIParts.BOLT).addTaggedPart('P', MIParts.PLATE).addTaggedPart('R', MIParts.RING);
        new ShapedRecipeBuilder(ctx, MIParts.HAMMER, 1, "hammer", "ppp", " s ", " s ").addTaggedPart('p', MIParts.PLATE).addInput('s', "minecraft:stick");
        new ShapedRecipeBuilder(ctx, MIParts.RING, 2, "ring", "bRb", "R R", "bRb").addTaggedPart('b', MIParts.BOLT).addTaggedPart('R', MIParts.ROD);
        new ShapedRecipeBuilder(ctx, MIParts.CABLE, 3, "cable", "rrr", "www", "rrr").addInput('r', "modern_industrialization:rubber_sheet").addTaggedPart('w', MIParts.WIRE).exportToMachine(MIMachineRecipeTypes.PACKER);
        new ShapedRecipeBuilder(ctx, MIParts.TANK, 1, "tank", "###", "#G#", "###").addTaggedPart('#', MIParts.PLATE).addInput('G', "minecraft:glass").exportToAssembler();
        new ShapedRecipeBuilder(ctx, MIParts.BARREL, 1, "barrel", "###", "#b#", "###").addTaggedPart('#', MIParts.PLATE).addInput('b', "minecraft:barrel").exportToAssembler();
        new ShapedRecipeBuilder(ctx, MIParts.DRILL_HEAD, 1, "drill_head", "bcp", "GRc", "bGb").addTaggedPart('G', MIParts.GEAR).addPart('b', MIParts.BOLT).addPart('c', MIParts.CURVED_PLATE).addPart('R', MIParts.ROD).addTaggedPart('p', MIParts.PLATE);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.DOUBLE_INGOT, 18);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.PLATE, 9);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.CURVED_PLATE, 9);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.NUGGET, 1);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.LARGE_PLATE, 36);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.GEAR, 18);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.RING, 4);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.BOLT, 2);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.ROD, 4);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.ROTOR, 27);
        if (!ctx.getMainPart().equals(MIParts.DUST)) {
            StandardRecipes.addMaceratorRecycling(ctx, ctx.getMainPart(), 9);
        }
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.BLADE, 5);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.DRILL_HEAD, 67);
        StandardRecipes.addMaceratorRecycling(ctx, MIParts.WIRE, 4);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.MACERATOR, "ore_to_crushed").addTaggedPartInput(MIParts.ORE, 1).addPartOutput(MIParts.CRUSHED_DUST, 3);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.MACERATOR, "ore_to_raw").addTaggedPartInput(MIParts.ORE, 1).addPartOutput(MIParts.RAW_METAL, 3);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.MACERATOR, "crushed_dust", 2, (int)(100.0 * ctx.getHardness().timeFactor)).addTaggedPartInput(MIParts.CRUSHED_DUST, 1).addPartOutput(MIParts.DUST, 1).addPartOutput(MIParts.DUST, 1, 0.5);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.MACERATOR, "raw_metal", 2, (int)(100.0 * ctx.getHardness().timeFactor)).addTaggedPartInput(MIParts.RAW_METAL, 1).addPartOutput(MIParts.DUST, 1).addPartOutput(MIParts.DUST, 1, 0.5);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.COMPRESSOR, "main").addTaggedPartInput(ctx.getMainPart(), 1).addPartOutput(MIParts.PLATE, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.COMPRESSOR, "plate").addTaggedPartInput(MIParts.PLATE, 1).addPartOutput(MIParts.CURVED_PLATE, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.COMPRESSOR, "double_ingot").addTaggedPartInput(MIParts.DOUBLE_INGOT, 1).addPartOutput(MIParts.PLATE, 2);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.COMPRESSOR, "ring").addTaggedPartInput(MIParts.ROD, 1).addPartOutput(MIParts.RING, 1);
        StandardRecipes.addCuttingMachine(ctx, "main", ctx.getMainPart(), MIParts.ROD, 2);
        StandardRecipes.addCuttingMachine(ctx, "double_ingot", MIParts.DOUBLE_INGOT, MIParts.ROD, 4);
        StandardRecipes.addCuttingMachine(ctx, "rod", MIParts.ROD, MIParts.BOLT, 2);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.PACKER, "block").addTaggedPartInput(ctx.getMainPart(), 9).addInput("modern_industrialization:packer_block_template", 1, 0.0).addPartOutput(MIParts.BLOCK, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.PACKER, "double_ingot").addTaggedPartInput(MIParts.INGOT, 2).addInput("modern_industrialization:packer_double_ingot_template", 1, 0.0).addPartOutput(MIParts.DOUBLE_INGOT, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.PACKER, "fuel_rod_double").addPartInput(MIParts.FUEL_ROD, 2).addInput("#c:nuclear_alloy_plates", 1).addPartOutput(MIParts.FUEL_ROD_DOUBLE, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.PACKER, "fuel_rod_quad").addInput("#c:nuclear_alloy_plates", 2).addPartInput(MIParts.FUEL_ROD_DOUBLE, 2).addPartOutput(MIParts.FUEL_ROD_QUAD, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.WIREMILL, "wire").addTaggedPartInput(MIParts.PLATE, 1).addPartOutput(MIParts.WIRE, 2);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.WIREMILL, "fine_wire").addTaggedPartInput(MIParts.WIRE, 1).addPartOutput(MIParts.FINE_WIRE, 4);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.ASSEMBLER, "rotor").addTaggedPartInput(MIParts.BLADE, 4).addTaggedPartInput(MIParts.RING, 1).addFluidInput("modern_industrialization:soldering_alloy", 100).addPartOutput(MIParts.ROTOR, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.ASSEMBLER, "gear").addTaggedPartInput(MIParts.PLATE, 4).addTaggedPartInput(MIParts.RING, 1).addFluidInput("modern_industrialization:soldering_alloy", 100).addPartOutput(MIParts.GEAR, 2);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.ASSEMBLER, "drill_head").addTaggedPartInput(MIParts.PLATE, 1).addTaggedPartInput(MIParts.CURVED_PLATE, 2).addTaggedPartInput(MIParts.ROD, 1).addTaggedPartInput(MIParts.GEAR, 2).addFluidInput("modern_industrialization:soldering_alloy", 75).addPartOutput(MIParts.DRILL_HEAD, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.ASSEMBLER, "fuel_rod", 16, 200).addInput("modern_industrialization:blastproof_alloy_curved_plate", 2).addInput("modern_industrialization:large_motor", 1).addInput("modern_industrialization:robot_arm", 2).addTaggedPartInput(MIParts.ROD, 18).addFluidInput("modern_industrialization:soldering_alloy", 500).addFluidInput("modern_industrialization:helium", 100).addPartOutput(MIParts.FUEL_ROD, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.HEAT_EXCHANGER, "hot_ingot", 8, 10).addPartInput(MIParts.HOT_INGOT, 1).addFluidInput(MIFluids.CRYOFLUID.id, 100).addPartOutput(MIParts.INGOT, 1).addFluidOutput(MIFluids.ARGON.id, 65).addFluidOutput(MIFluids.HELIUM.id, 25);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.POLARIZER, "rod_magnetic", 8, 200).addTaggedPartInput(MIParts.ROD, 1).addPartOutput(MIParts.ROD_MAGNETIC, 1);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.POLARIZER, "wire_magnetic", 8, 200).addTaggedPartInput(MIParts.WIRE, 1).addPartOutput(MIParts.WIRE_MAGNETIC, 1);
        new SmeltingRecipeBuilder(ctx, MIParts.ROD_MAGNETIC, MIParts.ROD, 0.0, false);
        new SmeltingRecipeBuilder(ctx, MIParts.WIRE_MAGNETIC, MIParts.WIRE, 0.0, false);
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.VACUUM_FREEZER, "hot_ingot", 32, 250).addTaggedPartInput(MIParts.HOT_INGOT, 1).addPartOutput(MIParts.INGOT, 1);
    }

    private static void addMaceratorRecycling(MaterialBuilder.RecipeContext ctx, Part partInput, int tinyDustOutput) {
        MIRecipeBuilder builder = new MIRecipeBuilder(ctx, MIMachineRecipeTypes.MACERATOR, partInput);
        builder.addTaggedPartInput(partInput, 1);
        if (tinyDustOutput % 9 == 0) {
            builder.addPartOutput(MIParts.DUST, tinyDustOutput / 9);
        } else {
            builder.addPartOutput(MIParts.TINY_DUST, tinyDustOutput);
        }
    }

    private static void add3By3Crafting(MaterialBuilder.RecipeContext ctx, Part smallPart, Part bigPart, boolean packer) {
        new ShapedRecipeBuilder(ctx, bigPart, 1, bigPart + "_from_" + smallPart, "yxx", "xxx", "xxx").addPart('y', smallPart).addTaggedPart('x', smallPart);
        new ShapedRecipeBuilder(ctx, smallPart, 9, smallPart + "_from_" + bigPart, "x").addPart('x', bigPart);
        if (packer) {
            new MIRecipeBuilder(ctx, MIMachineRecipeTypes.PACKER, bigPart).addTaggedPartInput(smallPart, 9).addPartOutput(bigPart, 1);
        }
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.UNPACKER, smallPart).addTaggedPartInput(bigPart, 1).addPartOutput(smallPart, 9);
    }

    private static void addCuttingMachine(MaterialBuilder.RecipeContext ctx, String name, Part inputPart, Part outputPart, int amount) {
        new MIRecipeBuilder(ctx, MIMachineRecipeTypes.CUTTING_MACHINE, name).addTaggedPartInput(inputPart, 1).addPartOutput(outputPart, amount).addFluidInput("modern_industrialization:lubricant", 1);
    }
}

