/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.materials.recipe.builder;

import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import aztech.modern_industrialization.materials.MaterialBuilder;
import aztech.modern_industrialization.materials.part.MaterialPart;
import aztech.modern_industrialization.materials.part.Part;
import aztech.modern_industrialization.materials.recipe.builder.MaterialRecipeBuilder;
import aztech.modern_industrialization.recipe.json.MIRecipeJson;
import com.google.gson.Gson;
import java.util.function.Consumer;
import net.minecraft.class_2444;

public class MIRecipeBuilder
implements MaterialRecipeBuilder {
    private static final Gson GSON = new Gson();
    public final String recipeId;
    private final MaterialBuilder.RecipeContext context;
    private boolean canceled = false;
    private final MIRecipeJson json;

    public MIRecipeBuilder(MaterialBuilder.RecipeContext context, MachineRecipeType type, String recipeSuffix, int eu, int duration) {
        this(context, type, recipeSuffix, MIRecipeJson.create(type, eu, duration));
    }

    public MIRecipeBuilder(MaterialBuilder.RecipeContext context, MachineRecipeType type, String recipeSuffix, MIRecipeJson json) {
        this.recipeId = type.getPath() + "/" + recipeSuffix;
        this.context = context;
        this.json = json;
        context.addRecipe(this);
    }

    public MIRecipeBuilder(MaterialBuilder.RecipeContext context, MachineRecipeType type, String recipeSuffix) {
        this(context, type, recipeSuffix, 2, (int)(200.0 * context.getHardness().timeFactor));
    }

    public MIRecipeBuilder(MaterialBuilder.RecipeContext context, MachineRecipeType type, Part recipeSuffix) {
        this(context, type, recipeSuffix.key);
    }

    public MIRecipeBuilder addPartInput(Part part, int amount) {
        return this.addPartInput(this.context.getPart(part), amount);
    }

    public MIRecipeBuilder addTaggedPartInput(Part part, int amount) {
        return this.addTaggedPartInput(this.context.getPart(part), amount);
    }

    public MIRecipeBuilder addPartInput(MaterialPart part, int amount) {
        if (part == null) {
            this.canceled = true;
        } else {
            this.addItemInput(part.getItemId(), amount);
        }
        return this;
    }

    public MIRecipeBuilder addTaggedPartInput(MaterialPart part, int amount) {
        if (part == null) {
            this.canceled = true;
        } else {
            this.addItemInput(part.getTaggedItemId(), amount);
        }
        return this;
    }

    public MIRecipeBuilder addItemInput(String maybeTag, int amount) {
        this.json.addItemInput(maybeTag, amount);
        return this;
    }

    public MIRecipeBuilder addFluidInput(String fluid, int amount) {
        this.json.addFluidInput(fluid, amount);
        return this;
    }

    public MIRecipeBuilder addFluidOutput(String fluid, int amount) {
        this.json.addFluidOutput(fluid, amount);
        return this;
    }

    public MIRecipeBuilder addPartOutput(Part part, int amount) {
        return this.addPartOutput(this.context.getPart(part), amount);
    }

    public MIRecipeBuilder addPartOutput(MaterialPart part, int amount) {
        if (part != null) {
            return this.addOutput(part.getItemId(), amount);
        }
        this.canceled = true;
        return this;
    }

    public MIRecipeBuilder addOutput(String itemId, int amount) {
        this.json.addItemOutput(itemId, amount);
        return this;
    }

    public MIRecipeBuilder addPartOutput(Part part, int amount, double probability) {
        return this.addPartOutput(this.context.getPart(part), amount, probability);
    }

    public MIRecipeBuilder addPartOutput(MaterialPart part, int amount, double probability) {
        if (part != null) {
            return this.addOutput(part.getItemId(), amount, probability);
        }
        this.canceled = true;
        return this;
    }

    public MIRecipeBuilder addOutput(String itemId, int amount, double probability) {
        this.json.addItemOutput(itemId, amount, probability);
        return this;
    }

    public MIRecipeBuilder addInput(String itemId, int amount, double probability) {
        this.json.addItemInput(itemId, amount, probability);
        return this;
    }

    public MIRecipeBuilder addInput(String itemId, int amount) {
        this.json.addItemInput(itemId, amount);
        return this;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public String getRecipeId() {
        return this.recipeId;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void save(Consumer<class_2444> consumer) {
        if (!this.canceled) {
            String fullId = "materials/" + this.context.getMaterialName() + "/" + this.recipeId;
            this.json.offerTo(consumer, fullId);
        }
    }
}

