/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.NuclearComponentItem;
import aztech.modern_industrialization.util.TextHelper;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3532;

public class NuclearAbsorbable
extends NuclearComponentItem {
    public final int desintegrationMax;

    public NuclearAbsorbable(class_1792.class_1793 settings, int maxTemperature, double heatConduction, INeutronBehaviour neutronBehaviour, int desintegrationMax) {
        super(settings, maxTemperature, heatConduction, neutronBehaviour);
        this.desintegrationMax = desintegrationMax;
    }

    public void setRemainingDesintegrations(class_1799 stack, int value) {
        Preconditions.checkArgument((boolean)(value >= 0 & value <= this.desintegrationMax), (Object)String.format("Remaining desintegration %d must be between 0 and max desintegration = %d", value, this.desintegrationMax));
        class_2487 tag = stack.method_7948();
        tag.method_10569("desRem", value);
    }

    public static NuclearComponentItem of(String id, int maxTemperature, double heatConduction, INeutronBehaviour neutronBehaviour, int desintegrationMax) {
        return MIItem.of(settings -> new NuclearAbsorbable((class_1792.class_1793)settings, maxTemperature, heatConduction, neutronBehaviour, desintegrationMax), id, 1);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)new class_2588("text.modern_industrialization.rem_absorption", new Object[]{this.getRemainingDesintegrations(stack), this.desintegrationMax}).method_10862(TextHelper.GRAY_TEXT));
    }

    public double getDurabilityBarProgress(class_1799 stack) {
        return (double)this.getRemainingDesintegrations(stack) / (double)this.desintegrationMax;
    }

    public int method_31571(class_1799 stack) {
        float f = (float)this.getRemainingDesintegrations(stack) / (float)this.desintegrationMax;
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean method_31567(class_1799 stack) {
        return this.getRemainingDesintegrations(stack) != this.desintegrationMax;
    }

    public int method_31569(class_1799 stack) {
        return (int)Math.round(this.getDurabilityBarProgress(stack) * 13.0);
    }

    public int getRemainingDesintegrations(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null || !tag.method_10545("desRem")) {
            return this.desintegrationMax;
        }
        return tag.method_10550("desRem");
    }

    protected static int randIntFromDouble(double value, Random rand) {
        return (int)Math.floor(value) + (rand.nextDouble() < value % 1.0 ? 1 : 0);
    }

    public int simulateAbsorption(double neutronsReceived, class_1799 stack, Random rand) {
        int absorbNeutrons = Math.min(NuclearAbsorbable.randIntFromDouble(neutronsReceived, rand), this.getRemainingDesintegrations(stack));
        this.setRemainingDesintegrations(stack, this.getRemainingDesintegrations(stack) - absorbNeutrons);
        return absorbNeutrons;
    }
}

