/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.nuclear.INeutronBehaviour;

public class NuclearConstant {
    public static final int EU_FOR_FAST_NEUTRON = 8;
    public static final int DESINTEGRATION_BY_ROD = 10240000;
    public static final double BASE_HEAT_CONDUCTION = 0.01;
    public static final double BASE_NEUTRON = 0.1;
    public static final int MAX_TEMPERATURE = 3250;
    public static final int EU_PER_DEGREE = 64;
    public static final int MAX_HATCH_EU_PRODUCTION = 8192;
    public static final IsotopeFuelParams U235 = new IsotopeFuelParams(0.6, 0.35, 2400, 900, 2300, 8.0, 0.5);
    public static final IsotopeFuelParams U238 = new IsotopeFuelParams(0.6, 0.3, 3200, 1000, 3000, 6.0, 0.3);
    public static final IsotopeFuelParams Pu239 = new IsotopeFuelParams(0.9, 0.25, 2100, 600, 2000, 9.0, 0.25);
    public static final IsotopeFuelParams U = U238.mix(U235, 0.012345679012345678);
    public static final IsotopeFuelParams LEU = U238.mix(U235, 0.1111111111111111);
    public static final IsotopeFuelParams HEU = U238.mix(U235, 0.3333333333333333);
    public static final IsotopeFuelParams LE_MOX = U238.mix(Pu239, 0.1111111111111111);
    public static final IsotopeFuelParams HE_MOX = U238.mix(Pu239, 0.3333333333333333);
    public static final IsotopeParams HYDROGEN = new IsotopeParams(0.1, 0.05, 0.25, 0.75);
    public static final IsotopeParams DEUTERIUM = new IsotopeParams(0.02, 0.01, 0.15, 0.65);
    public static final IsotopeParams CADMIUM = new IsotopeParams(0.95, 0.9, 0.05, 0.1);
    public static final IsotopeParams CARBON = new IsotopeParams(0.01, 0.005, 0.5, 0.85);

    public static class IsotopeFuelParams
    extends IsotopeParams {
        public final int maxTemp;
        public final double neutronsMultiplication;
        public final double directEnergyFactor;
        public final int tempLimitLow;
        public final int tempLimitHigh;

        public IsotopeFuelParams(double thermalAbsorbProba, double thermalScatterings, int maxTemp, int tempLimitLow, int tempLimitHigh, double neutronsMultiplication, double directEnergyFactor) {
            super(thermalAbsorbProba, INeutronBehaviour.reduceCrossProba(thermalAbsorbProba, 0.1), thermalScatterings, INeutronBehaviour.reduceCrossProba(thermalScatterings, 0.5));
            this.maxTemp = maxTemp;
            this.neutronsMultiplication = neutronsMultiplication;
            this.directEnergyFactor = directEnergyFactor;
            this.tempLimitLow = tempLimitLow;
            this.tempLimitHigh = tempLimitHigh;
        }

        public static IsotopeFuelParams mix(IsotopeFuelParams a, IsotopeFuelParams b, double factor) {
            factor = 1.0 - factor;
            double newThermalAbsorptionProba = INeutronBehaviour.probaFromCrossSection(IsotopeFuelParams.mix(a.thermalAbsorption, b.thermalAbsorption, factor));
            double newScatteringProba = INeutronBehaviour.probaFromCrossSection(IsotopeFuelParams.mix(a.thermalScattering, b.thermalScattering, factor));
            double newNeutronMultiplicationFactor = IsotopeFuelParams.mix(a.neutronsMultiplication, b.neutronsMultiplication, factor);
            double totalEnergy = IsotopeFuelParams.mix(a.neutronsMultiplication * (1.0 + a.directEnergyFactor), b.neutronsMultiplication * (1.0 + b.directEnergyFactor), factor);
            int newMaxTemp = (int)IsotopeFuelParams.mix(a.maxTemp, b.maxTemp, factor);
            int newTempLimitLow = (int)IsotopeFuelParams.mix(a.tempLimitLow, b.tempLimitLow, factor);
            int newTempLimitHigh = (int)IsotopeFuelParams.mix(a.tempLimitHigh, b.tempLimitHigh, factor);
            double newDirectEnergyFactor = totalEnergy / newNeutronMultiplicationFactor - 1.0;
            return new IsotopeFuelParams(newThermalAbsorptionProba, newScatteringProba, newMaxTemp, newTempLimitLow, newTempLimitHigh, newNeutronMultiplicationFactor, newDirectEnergyFactor);
        }

        private static double mix(double a, double b, double r) {
            return r * a + (1.0 - r) * b;
        }

        public IsotopeFuelParams mix(IsotopeFuelParams b, double factor) {
            return IsotopeFuelParams.mix(this, b, factor);
        }
    }

    public static class IsotopeParams {
        public final double thermalAbsorption;
        public final double fastAbsorption;
        public final double fastScattering;
        public final double thermalScattering;

        public IsotopeParams(double thermalAbsorbProba, double fastAbsorptionProba, double thermalScatteringProba, double fastScatteringProba) {
            this.thermalAbsorption = INeutronBehaviour.crossSectionFromProba(thermalAbsorbProba);
            this.fastAbsorption = INeutronBehaviour.crossSectionFromProba(fastAbsorptionProba);
            this.thermalScattering = INeutronBehaviour.crossSectionFromProba(thermalScatteringProba);
            this.fastScattering = INeutronBehaviour.crossSectionFromProba(fastScatteringProba);
        }
    }

    public static enum ScatteringType {
        ULTRA_LIGHT(0.05),
        LIGHT(0.2),
        MEDIUM(0.5),
        HEAVY(0.85);

        public final double fastFraction;
        public final double slowFraction;

        private ScatteringType(double fastFraction) {
            this.fastFraction = fastFraction;
            this.slowFraction = 1.0 - this.fastFraction;
        }
    }
}

