/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.nuclear;

import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.nuclear.INeutronBehaviour;
import aztech.modern_industrialization.nuclear.INuclearGrid;
import aztech.modern_industrialization.nuclear.NuclearAbsorbable;
import aztech.modern_industrialization.util.TextHelper;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class NuclearFuel
extends NuclearAbsorbable {
    public final double directEnergyFactor;
    public final double neutronMultiplicationFactor;
    public final String depletedVersionId;
    public final int size;
    public final int directEUbyDesintegration;
    public final int totalEUbyDesintegration;
    public final int tempLimitLow;
    public final int tempLimitHigh;

    public NuclearFuel(class_1792.class_1793 settings, NuclearFuelParams params, INeutronBehaviour neutronBehaviour, String depletedVersionId) {
        this(settings, params.desintegrationMax, params.maxTemperature, params.tempLimitLow, params.tempLimitHigh, params.neutronMultiplicationFactor, params.directEnergyFactor, neutronBehaviour, params.size, depletedVersionId);
    }

    private static int clampTemp(int temperature) {
        return 25 * (int)((double)temperature / 25.0);
    }

    private NuclearFuel(class_1792.class_1793 settings, int desintegrationMax, int maxTemperature, int tempLimitLow, int tempLimitHigh, double neutronMultiplicationFactor, double directEnergyFactor, INeutronBehaviour neutronBehaviour, int size, String depletedVersionId) {
        super(settings, NuclearFuel.clampTemp(maxTemperature), 0.008, neutronBehaviour, desintegrationMax);
        this.size = size;
        this.directEnergyFactor = directEnergyFactor;
        this.neutronMultiplicationFactor = neutronMultiplicationFactor;
        this.depletedVersionId = depletedVersionId;
        this.tempLimitLow = NuclearFuel.clampTemp(tempLimitLow);
        this.tempLimitHigh = NuclearFuel.clampTemp(tempLimitHigh);
        this.directEUbyDesintegration = (int)(8.0 * directEnergyFactor * neutronMultiplicationFactor);
        this.totalEUbyDesintegration = (int)(8.0 * (1.0 + directEnergyFactor) * neutronMultiplicationFactor);
    }

    public static NuclearFuel of(String id, NuclearFuelParams params, INeutronBehaviour neutronBehaviour, String depletedVersionId) {
        return MIItem.of(settings -> new NuclearFuel((class_1792.class_1793)settings, params, neutronBehaviour, depletedVersionId), id, 1);
    }

    @Override
    public ItemVariant getNeutronProduct() {
        return ItemVariant.of((class_1935)((class_1935)class_2378.field_11142.method_17966((class_2960)new MIIdentifier(this.depletedVersionId)).get()));
    }

    @Override
    public long getNeutronProductAmount() {
        return this.size;
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        long totalEu = (long)this.totalEUbyDesintegration * (long)this.desintegrationMax;
        tooltip.add(TextHelper.getEuStorageTooltip(totalEu));
    }

    public double efficiencyFactor(double temperature) {
        double factor = 1.0;
        if (temperature > (double)this.tempLimitLow) {
            factor = Math.max(0.0, 1.0 - (temperature - (double)this.tempLimitLow) / (double)(this.tempLimitHigh - this.tempLimitLow));
        }
        return factor;
    }

    public int simulateDesintegration(double neutronsReceived, class_1799 stack, double temperature, Random rand, INuclearGrid grid) {
        int absorption = this.simulateAbsorption(neutronsReceived, stack, rand);
        double fuelEuConsumed = absorption * this.totalEUbyDesintegration;
        grid.registerEuFuelConsumption(fuelEuConsumed);
        return NuclearFuel.randIntFromDouble(this.efficiencyFactor(temperature) * (double)absorption * this.neutronMultiplicationFactor, rand);
    }

    public record NuclearFuelParams(int desintegrationMax, int maxTemperature, int tempLimitLow, int tempLimitHigh, double neutronMultiplicationFactor, double directEnergyFactor, int size) {
    }
}

