/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.impl.PipeNetworks;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2246;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;

public class MIPipesCommands {
    private static final SuggestionProvider<class_2168> SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9257(PipeNetworkType.getTypes().keySet().stream(), (SuggestionsBuilder)builder);

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            if (!MIConfig.getConfig().enableDebugCommands) {
                return;
            }
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mi").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"pipes").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)"clear").executes(ctx -> MIPipesCommands.clearPipes((class_2168)ctx.getSource(), class_2262.method_9696((CommandContext)ctx, (String)"pos"))))).then(class_2170.method_9247((String)"add_ghost").then(class_2170.method_9244((String)"pipe_type", (ArgumentType)class_2232.method_9441()).suggests(SUGGESTION_PROVIDER).executes(ctx -> MIPipesCommands.addGhostPipe((class_2168)ctx.getSource(), class_2262.method_9696((CommandContext)ctx, (String)"pos"), class_2232.method_9443((CommandContext)ctx, (String)"pipe_type"))))))));
        });
    }

    private static int clearPipes(class_2168 src, class_2338 pos) {
        if (src.method_9225().method_8320(pos).method_27852(MIPipes.BLOCK_PIPE)) {
            src.method_9225().method_8501(pos, class_2246.field_10124.method_9564());
        }
        PipeNetworks networks = PipeNetworks.get(src.method_9225());
        for (PipeNetworkType type : PipeNetworkType.getTypes().values()) {
            PipeNetworkManager manager = networks.getManager(type);
            if (!manager.hasNode(pos)) continue;
            manager.removeNode(pos);
            src.method_9226((class_2561)new class_2585("Successfully removed pipe of type %s at position %s.".formatted(type.getIdentifier(), pos)), true);
        }
        return 1;
    }

    private static int addGhostPipe(class_2168 src, class_2338 pos, class_2960 pipeType) throws CommandSyntaxException {
        PipeNetworkType type = PipeNetworkType.get(pipeType);
        if (type == null) {
            throw new SimpleCommandExceptionType((Message)new class_2585("Unknown pipe network type: " + pipeType)).create();
        }
        PipeNetworks networks = PipeNetworks.get(src.method_9225());
        PipeNetworkManager manager = networks.getManager(type);
        if (!manager.hasNode(pos)) {
            manager.addNode(type.getNodeCtor().get(), pos, MIPipes.INSTANCE.getPipeItem((PipeNetworkType)type).defaultData);
            src.method_9226((class_2561)new class_2585("Successfully added pipe of type %s at position %s.".formatted(type.getIdentifier(), pos)), true);
        } else {
            src.method_9226((class_2561)new class_2585("Failed to add pipe of type %s at position %s as it already existed.".formatted(type.getIdentifier(), pos)), true);
        }
        return 1;
    }
}

