/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.electricity;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyExtractable;
import aztech.modern_industrialization.api.energy.EnergyInsertable;
import aztech.modern_industrialization.pipes.api.PipeNetwork;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkData;
import aztech.modern_industrialization.pipes.electricity.ElectricityNetworkNode;
import aztech.modern_industrialization.util.Simulation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_3218;

public class ElectricityNetwork
extends PipeNetwork {
    final CableTier tier;

    public ElectricityNetwork(int id, PipeNetworkData data, CableTier tier) {
        super(id, data == null ? new ElectricityNetworkData() : data);
        this.tier = tier;
    }

    @Override
    public void tick(class_3218 world) {
        ArrayList<EnergyInsertable> insertables = new ArrayList<EnergyInsertable>();
        ArrayList<EnergyExtractable> extractables = new ArrayList<EnergyExtractable>();
        long networkAmount = 0L;
        int loadedNodeCount = 0;
        for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
            ElectricityNetworkNode node = (ElectricityNetworkNode)entry.getNode();
            node.appendAttributes(world, entry.getPos(), insertables, extractables);
            networkAmount += node.eu;
            ++loadedNodeCount;
        }
        insertables.removeIf(insertable -> !insertable.canInsert(this.tier));
        extractables.removeIf(extractable -> !extractable.canExtract(this.tier));
        long networkCapacity = (long)loadedNodeCount * this.tier.getMaxTransfer();
        long extractMaxAmount = Math.min(this.tier.getMaxTransfer(), networkCapacity - networkAmount);
        long insertMaxAmount = Math.min(this.tier.getMaxTransfer(), networkAmount += ElectricityNetwork.transferForTargets(EnergyExtractable::extractEnergy, extractables, extractMaxAmount));
        networkAmount -= ElectricityNetwork.transferForTargets(EnergyInsertable::insertEnergy, insertables, insertMaxAmount);
        for (PipeNetwork.PosNode entry : this.iterateTickingNodes()) {
            ElectricityNetworkNode electricityNode = (ElectricityNetworkNode)entry.getNode();
            electricityNode.eu = networkAmount / (long)loadedNodeCount;
            networkAmount -= electricityNode.eu;
            --loadedNodeCount;
        }
    }

    private static <T> long transferForTargets(TransferOperation<T> operation, List<T> targets, long maxAmount) {
        ArrayList<EnergyTarget> sortableTargets = new ArrayList<EnergyTarget>(targets.size());
        for (T t2 : targets) {
            sortableTargets.add(new EnergyTarget<T>(t2));
        }
        Collections.shuffle(sortableTargets);
        for (EnergyTarget energyTarget : sortableTargets) {
            energyTarget.simulationResult = operation.transfer(energyTarget.target, maxAmount, Simulation.SIMULATE);
        }
        sortableTargets.sort(Comparator.comparing(t -> t.simulationResult));
        long transferredAmount = 0L;
        for (int i = 0; i < sortableTargets.size(); ++i) {
            EnergyTarget target = (EnergyTarget)sortableTargets.get(i);
            int remainingTargets = sortableTargets.size() - i;
            long remainingAmount = maxAmount - transferredAmount;
            long targetMaxAmount = remainingAmount / (long)remainingTargets;
            transferredAmount += operation.transfer(target.target, targetMaxAmount, Simulation.ACT);
        }
        return transferredAmount;
    }

    @FunctionalInterface
    private static interface TransferOperation<T> {
        public long transfer(T var1, long var2, Simulation var4);
    }

    private static class EnergyTarget<T> {
        final T target;
        long simulationResult;

        EnergyTarget(T target) {
            this.target = target;
        }
    }
}

