/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.pipes.impl;

import aztech.modern_industrialization.pipes.api.PipeNetworkManager;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.impl.PipeBlockEntity;
import aztech.modern_industrialization.util.WorldHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class PipeNetworks
extends class_18 {
    private static final String NAME = "modern_industrialization_pipe_networks";
    private final Map<PipeNetworkType, PipeNetworkManager> managers;
    private final Map<Long, List<Runnable>> loadPipesByChunk = new HashMap<Long, List<Runnable>>();

    public PipeNetworks(Map<PipeNetworkType, PipeNetworkManager> managers) {
        this.managers = managers;
    }

    public PipeNetworkManager getManager(PipeNetworkType type) {
        return this.managers.computeIfAbsent(type, PipeNetworkManager::new);
    }

    public class_2487 method_75(class_2487 nbt) {
        for (Map.Entry<PipeNetworkType, PipeNetworkManager> entry : this.managers.entrySet()) {
            nbt.method_10566(entry.getKey().getIdentifier().toString(), (class_2520)entry.getValue().toTag(new class_2487()));
        }
        return nbt;
    }

    public static PipeNetworks readNbt(class_2487 nbt) {
        HashMap<PipeNetworkType, PipeNetworkManager> managers = new HashMap<PipeNetworkType, PipeNetworkManager>();
        for (Map.Entry<class_2960, PipeNetworkType> entry : PipeNetworkType.getTypes().entrySet()) {
            PipeNetworkManager manager = new PipeNetworkManager(entry.getValue());
            String tagKey = entry.getKey().toString();
            if (nbt.method_10545(tagKey)) {
                manager.fromNbt(nbt.method_10562(tagKey));
            }
            managers.put(entry.getValue(), manager);
        }
        return new PipeNetworks(managers);
    }

    public static PipeNetworks get(class_3218 world) {
        PipeNetworks networks = (PipeNetworks)world.method_17983().method_17924(PipeNetworks::readNbt, () -> new PipeNetworks(new HashMap<PipeNetworkType, PipeNetworkManager>()), NAME);
        networks.method_80();
        return networks;
    }

    public static void scheduleLoadPipe(class_1937 world, PipeBlockEntity pipe) {
        if (world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            if (!sw.method_8503().method_18854()) {
                throw new IllegalStateException("Can only load pipe on server from the server thread.");
            }
            PipeNetworks.get((class_3218)sw).loadPipesByChunk.computeIfAbsent(class_1923.method_37232((class_2338)pipe.method_11016()), chunk -> new ArrayList()).add(pipe::loadPipes);
        }
    }

    static {
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            PipeNetworks networks = PipeNetworks.get(world);
            Iterator<Map.Entry<Long, List<Runnable>>> it = networks.loadPipesByChunk.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, List<Runnable>> chunkEntry = it.next();
                if (!WorldHelper.isChunkTicking(world, chunkEntry.getKey())) continue;
                chunkEntry.getValue().forEach(Runnable::run);
                it.remove();
            }
            for (PipeNetworkManager manager : networks.managers.values()) {
                manager.tickNetworks(world);
            }
        });
    }
}

