/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.textures;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class TextureManager {
    private final class_3300 rm;
    private final BiConsumer<class_1011, String> textureWriter;
    private final List<Runnable> endRunnables = new ArrayList<Runnable>();

    public TextureManager(class_3300 rm, BiConsumer<class_1011, String> textureWriter) {
        this.rm = rm;
        this.textureWriter = textureWriter;
    }

    public boolean hasAsset(String asset) {
        return this.rm.method_18234(new class_2960(asset));
    }

    public class_1011 getAssetAsTexture(String textureId) throws IOException {
        if (this.rm.method_18234(new class_2960(textureId))) {
            try (class_3298 texture = this.rm.method_14486(new class_2960(textureId));){
                class_1011 class_10112 = class_1011.method_4309((InputStream)texture.method_14482());
                return class_10112;
            }
        }
        throw new IOException("Couldn't find texture " + textureId);
    }

    public void addTexture(String textureId, class_1011 image) throws IOException {
        this.addTexture(textureId, image, false);
    }

    public void addTexture(String textureId, class_1011 image, boolean closeImage) throws IOException {
        class_2960 id = new class_2960(textureId);
        if (!this.rm.method_18234(id)) {
            this.textureWriter.accept(image, textureId);
        }
        if (closeImage) {
            image.close();
        }
    }

    public void runAtEnd(Runnable runnable) {
        this.endRunnables.add(runnable);
    }

    public void onEnd() {
        for (Runnable runnable : this.endRunnables) {
            runnable.run();
        }
        this.endRunnables.clear();
    }
}

