/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.util;

import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;

public class StorageUtil2 {
    @Nullable
    public static Storage<ItemVariant> wrapInventory(@Nullable Storage<ItemVariant> foundStorage) {
        if (foundStorage instanceof InventoryStorage) {
            InventoryStorage wrapper = (InventoryStorage)foundStorage;
            return new SmarterInventoryStorage(wrapper.getSlots());
        }
        return foundStorage;
    }

    private static class SmarterInventoryStorage
    extends CombinedStorage<ItemVariant, SingleSlotStorage<ItemVariant>> {
        public SmarterInventoryStorage(List<SingleSlotStorage<ItemVariant>> parts) {
            super(parts);
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
            long amount = 0L;
            for (int iter = 0; iter < 2; ++iter) {
                for (SingleSlotStorage part : this.parts) {
                    if (iter != 1 && part.isResourceBlank()) continue;
                    amount += part.insert((Object)resource, maxAmount - amount, transaction);
                }
            }
            return amount;
        }
    }
}

