/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.fabric.ae2wtlib.wet;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.blockentities.IViewCellStorage;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.IAEPatternDetails;
import appeng.helpers.IPatternTerminalHost;
import appeng.menu.ISubMenu;
import appeng.parts.encoding.EncodingMode;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import de.mari_023.fabric.ae2wtlib.AE2wtlib;
import de.mari_023.fabric.ae2wtlib.terminal.WTMenuHost;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class WETMenuHost
extends WTMenuHost
implements ISegmentedInventory,
IViewCellStorage,
IPatternTerminalHost {
    private EncodingMode mode = EncodingMode.CRAFTING;
    private boolean substitute = false;
    private boolean substituteFluids = true;
    private final AppEngInternalInventory crafting = new AppEngInternalInventory((InternalInventoryHost)this, 9);
    private final AppEngInternalInventory output = new AppEngInternalInventory((InternalInventoryHost)this, 3);
    private final AppEngInternalInventory pattern = new AppEngInternalInventory((InternalInventoryHost)this, 2);

    public WETMenuHost(class_1657 ep, @Nullable Integer inventorySlot, class_1799 is, BiConsumer<class_1657, ISubMenu> returnToMainMenu) {
        super(ep, inventorySlot, is, returnToMainMenu);
        this.readFromNbt();
    }

    public class_1799 getMainMenuIcon() {
        return new class_1799((class_1935)AE2wtlib.PATTERN_ENCODING_TERMINAL);
    }

    public InternalInventory getSubInventory(class_2960 id) {
        if (id.equals((Object)IPatternTerminalHost.INV_CRAFTING)) {
            return this.crafting;
        }
        if (id.equals((Object)IPatternTerminalHost.INV_OUTPUT)) {
            return this.output;
        }
        if (id.equals((Object)PATTERNS)) {
            return this.pattern;
        }
        return null;
    }

    public EncodingMode getMode() {
        return this.mode;
    }

    public void setMode(EncodingMode mode) {
        this.mode = mode;
        this.fixCraftingRecipes();
        this.saveChanges();
    }

    @Override
    protected void readFromNbt() {
        super.readFromNbt();
        class_2487 tag = this.getItemStack().method_7948();
        try {
            this.mode = EncodingMode.valueOf((String)tag.method_10558("wet_mode"));
        }
        catch (IllegalArgumentException ignored) {
            this.mode = EncodingMode.CRAFTING;
        }
        this.substitute = tag.method_10577("wet_substitute");
        this.substituteFluids = tag.method_10577("wet_substituteFluids");
        this.pattern.readFromNBT(tag, "wet_pattern");
        this.output.readFromNBT(tag, "wet_outputList");
        this.crafting.readFromNBT(tag, "wet_craftingGrid");
    }

    @Override
    public void saveChanges() {
        super.saveChanges();
        class_2487 tag = this.getItemStack().method_7948();
        tag.method_10582("wet_mode", this.mode.name());
        tag.method_10556("wet_substitute", this.substitute);
        tag.method_10556("wet_substituteFluids", this.substituteFluids);
        this.pattern.writeToNBT(tag, "wet_pattern");
        this.output.writeToNBT(tag, "wet_outputList");
        this.crafting.writeToNBT(tag, "wet_craftingGrid");
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.pattern && slot == 1) {
            class_1799 is = this.pattern.getStackInSlot(1);
            IPatternDetails details = PatternDetailsHelper.decodePattern((class_1799)is, (class_1937)this.getPlayer().method_37908());
            if (details instanceof AECraftingPattern) {
                this.setMode(EncodingMode.CRAFTING);
            } else if (details instanceof AEProcessingPattern) {
                this.setMode(EncodingMode.PROCESSING);
            }
            if (details instanceof IAEPatternDetails) {
                int x;
                IAEPatternDetails aeDetails = (IAEPatternDetails)details;
                this.setSubstitution(aeDetails.canSubstitute());
                this.setFluidSubstitution(aeDetails.canSubstituteFluids());
                for (x = 0; x < this.crafting.size() && x < aeDetails.getSparseInputs().length; ++x) {
                    this.crafting.setItemDirect(x, GenericStack.wrapInItemStack((GenericStack)aeDetails.getSparseInputs()[x]));
                }
                for (x = 0; x < this.output.size() && x < aeDetails.getSparseOutputs().length; ++x) {
                    this.output.setItemDirect(x, GenericStack.wrapInItemStack((GenericStack)aeDetails.getSparseOutputs()[x]));
                }
            }
        } else if (inv == this.crafting) {
            this.fixCraftingRecipes();
        }
        this.saveChanges();
    }

    public boolean isSubstitution() {
        return this.substitute;
    }

    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
        this.saveChanges();
    }

    public boolean isFluidSubstitution() {
        return this.substituteFluids;
    }

    public void setFluidSubstitution(boolean canSubstitute) {
        this.substituteFluids = canSubstitute;
        this.saveChanges();
    }
}

