/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.fabric.ae2wtlib.wut;

import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.menu.ISubMenu;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import de.mari_023.fabric.ae2wtlib.AE2wtlibConfig;
import de.mari_023.fabric.ae2wtlib.TextConstants;
import de.mari_023.fabric.ae2wtlib.terminal.IUniversalWirelessTerminalItem;
import de.mari_023.fabric.ae2wtlib.terminal.WTMenuHost;
import de.mari_023.fabric.ae2wtlib.trinket.TrinketLocator;
import de.mari_023.fabric.ae2wtlib.trinket.TrinketsHelper;
import de.mari_023.fabric.ae2wtlib.wut.ItemWUT;
import de.mari_023.fabric.ae2wtlib.wut.WTDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class WUTHandler {
    public static final Map<String, WTDefinition> wirelessTerminals = new HashMap<String, WTDefinition>();
    public static final List<String> terminalNames = new ArrayList<String>();

    public static String getCurrentTerminal(class_1799 terminal) {
        if (terminal.method_7909() instanceof ItemWUT) {
            String currentTerminal = terminal.method_7948().method_10558("currentTerminal");
            if (wirelessTerminals.containsKey(currentTerminal)) {
                return currentTerminal;
            }
            for (String term : terminalNames) {
                if (!terminal.method_7948().method_10577(term)) continue;
                currentTerminal = term;
                terminal.method_7948().method_10582("currentTerminal", currentTerminal);
                break;
            }
            return currentTerminal;
        }
        for (Map.Entry<String, WTDefinition> entry : wirelessTerminals.entrySet()) {
            if (!terminal.method_7909().equals(entry.getValue().item())) continue;
            return entry.getKey();
        }
        return "";
    }

    public static void setCurrentTerminal(class_1657 playerEntity, MenuLocator locator, class_1799 itemStack, String terminal) {
        if (!(itemStack.method_7909() instanceof ItemWUT)) {
            return;
        }
        if (!WUTHandler.hasTerminal(itemStack, terminal)) {
            return;
        }
        assert (itemStack.method_7969() != null);
        itemStack.method_7969().method_10582("currentTerminal", terminal);
        WUTHandler.updateClientTerminal((class_3222)playerEntity, locator, itemStack.method_7969());
    }

    public static boolean hasTerminal(class_1799 terminal, String terminalName) {
        if (terminal.method_7960() || terminal.method_7909() == null) {
            return false;
        }
        if (terminal.method_7909() instanceof ItemWUT) {
            if (!terminalNames.contains(terminalName)) {
                return false;
            }
            if (terminal.method_7969() == null) {
                return false;
            }
            return terminal.method_7969().method_10577(terminalName);
        }
        return terminal.method_7909().equals(wirelessTerminals.get(terminalName).item());
    }

    public static void cycle(class_1657 playerEntity, MenuLocator locator, class_1799 itemStack, boolean isHandlingRightClick) {
        if (itemStack.method_7969() == null) {
            return;
        }
        String nextTerminal = WUTHandler.getCurrentTerminal(itemStack);
        do {
            int i;
            if (isHandlingRightClick) {
                i = terminalNames.indexOf(nextTerminal) - 1;
                if (i == -1) {
                    i = terminalNames.size() - 1;
                }
            } else {
                i = terminalNames.indexOf(nextTerminal) + 1;
                if (i == terminalNames.size()) {
                    i = 0;
                }
            }
            nextTerminal = terminalNames.get(i);
        } while (!itemStack.method_7969().method_10577(nextTerminal));
        itemStack.method_7969().method_10582("currentTerminal", nextTerminal);
        WUTHandler.updateClientTerminal((class_3222)playerEntity, locator, itemStack.method_7969());
    }

    public static void updateClientTerminal(class_3222 playerEntity, MenuLocator locator, @Nullable class_2487 tag) {
        class_2540 buf = PacketByteBufs.create();
        MenuLocators.writeToPacket((class_2540)buf, (MenuLocator)locator);
        buf.method_10794(tag);
        ServerPlayNetworking.send((class_3222)playerEntity, (class_2960)new class_2960("ae2wtlib", "update_wut"), (class_2540)buf);
    }

    public static boolean open(class_1657 player, MenuLocator locator) {
        WTMenuHost host = (WTMenuHost)((Object)locator.locate(player, WTMenuHost.class));
        if (host == null) {
            return false;
        }
        class_1799 is = host.getItemStack();
        if (is.method_7969() == null) {
            return false;
        }
        String currentTerminal = WUTHandler.getCurrentTerminal(is);
        if (!wirelessTerminals.containsKey(currentTerminal)) {
            player.method_7353((class_2561)TextConstants.TERMINAL_EMPTY, false);
            return false;
        }
        return wirelessTerminals.get(currentTerminal).containerOpener().tryOpen(player, locator, is);
    }

    @Nullable
    public static MenuLocator findTerminal(class_1657 player, String terminalName) {
        TrinketLocator trinketLocator;
        if (AE2wtlibConfig.INSTANCE.allowTrinket() && (trinketLocator = TrinketsHelper.findTerminal(player, terminalName)) != null) {
            return trinketLocator;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            if (!WUTHandler.hasTerminal(player.method_31548().method_5438(i), terminalName)) continue;
            return MenuLocators.forInventorySlot((int)i);
        }
        return null;
    }

    public static class_1799 getItemStackFromLocator(class_1657 player, MenuLocator locator) {
        if (locator instanceof TrinketLocator) {
            TrinketLocator trinketLocator = (TrinketLocator)locator;
            return trinketLocator.locateItem(player);
        }
        ItemMenuHost host = (ItemMenuHost)locator.locate(player, WTMenuHost.class);
        if (host == null) {
            return class_1799.field_8037;
        }
        return host.getItemStack();
    }

    public static void addTerminal(String name, ContainerOpener open, WTMenuHostFactory WTMenuHostFactory2, class_3917<?> menuType, IUniversalWirelessTerminalItem item) {
        if (terminalNames.contains(name)) {
            return;
        }
        wirelessTerminals.put(name, new WTDefinition(open, WTMenuHostFactory2, menuType, item));
        terminalNames.add(name);
    }

    @FunctionalInterface
    public static interface ContainerOpener {
        public boolean tryOpen(class_1657 var1, MenuLocator var2, class_1799 var3);
    }

    @FunctionalInterface
    public static interface WTMenuHostFactory {
        public WTMenuHost create(class_1657 var1, @Nullable Integer var2, class_1799 var3, BiConsumer<class_1657, ISubMenu> var4);
    }
}

