/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.entity;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_1068;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_5944;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_909;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.EntityDoppleganger;

public class RenderDoppleganger
extends class_909<EntityDoppleganger, class_572<EntityDoppleganger>> {
    public static final float DEFAULT_GRAIN_INTENSITY = 0.05f;
    public static final float DEFAULT_DISFIGURATION = 0.025f;
    private final Model normalModel = (Model)this.method_4038();
    private final Model slimModel;

    public RenderDoppleganger(class_5617.class_5618 ctx) {
        super(ctx, (class_572)new Model(ctx.method_32167(class_5602.field_27577)), 0.0f);
        this.slimModel = new Model(ctx.method_32167(class_5602.field_27581));
    }

    public void render(@Nonnull EntityDoppleganger dopple, float yaw, float partialTicks, class_4587 ms, class_4597 buffers, int light) {
        class_1297 view;
        int invulTime = dopple.getInvulTime();
        class_5944 shader = CoreShaders.doppleganger();
        if (shader != null) {
            float disfiguration;
            float grainIntensity;
            if (invulTime > 0) {
                grainIntensity = invulTime > 20 ? 1.0f : (float)invulTime * 0.05f;
                disfiguration = grainIntensity * 0.3f;
            } else {
                disfiguration = (0.025f + (float)dopple.field_6235 * 0.0425f) / 2.0f;
                grainIntensity = 0.05f + (float)dopple.field_6235 * 0.085f;
            }
            shader.method_35785("BotaniaGrainIntensity").method_1251(grainIntensity);
            shader.method_35785("BotaniaDisfiguration").method_1251(disfiguration);
        }
        this.field_4737 = (view = class_310.method_1551().method_1560()) instanceof class_742 && class_1068.method_4647((UUID)view.method_5667()).equals("slim") ? this.slimModel : this.normalModel;
        super.method_4072((class_1308)dopple, yaw, partialTicks, ms, buffers, light);
    }

    @Nonnull
    public class_2960 getTextureLocation(@Nonnull EntityDoppleganger entity) {
        class_310 mc = class_310.method_1551();
        if (!(mc.method_1560() instanceof class_742)) {
            return class_1068.method_4648((UUID)entity.method_5667());
        }
        return ((class_742)mc.method_1560()).method_3117();
    }

    protected boolean isBodyVisible(EntityDoppleganger dopple) {
        return true;
    }

    private static class Model
    extends class_572<EntityDoppleganger> {
        Model(class_630 root) {
            super(root, RenderHelper::getDopplegangerLayer);
        }
    }
}

