/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.ModSubtiles;

public class SubTileBergamute
extends TileEntitySpecialFlower {
    private static final int RANGE = 4;
    private static final Set<SubTileBergamute> existingFlowers = Collections.newSetFromMap(new WeakHashMap());
    private static final Set<class_1113> mutedSounds = Collections.newSetFromMap(new WeakHashMap());
    private boolean disabled = false;

    public SubTileBergamute(class_2338 pos, class_2680 state) {
        super(ModSubtiles.BERGAMUTE, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().field_9236) {
            this.disabled = this.method_10997().method_8479(this.method_11016());
            existingFlowers.add(this);
        }
    }

    public void method_11012() {
        super.method_11012();
        existingFlowers.remove(this);
    }

    private static Pair<Integer, SubTileBergamute> getBergamutesNearby(double x, double y, double z, int maxCount) {
        int count = 0;
        SubTileBergamute tile = null;
        for (SubTileBergamute f : existingFlowers) {
            if (f.disabled || !(f.getEffectivePos().method_10268(x, y, z, true) <= 16.0)) continue;
            if (++count == 1) {
                tile = f;
            }
            if (count < maxCount) continue;
            break;
        }
        return Pair.of((Object)count, tile);
    }

    public static boolean isBergamuteNearby(double x, double y, double z) {
        return (Integer)SubTileBergamute.getBergamutesNearby(x, y, z, 1).getFirst() > 0;
    }

    @Environment(value=EnvType.CLIENT)
    public static int countFlowersAround(class_1113 sound) {
        Pair<Integer, SubTileBergamute> countAndBerg = SubTileBergamute.getBergamutesNearby(sound.method_4784(), sound.method_4779(), sound.method_4778(), 8);
        int count = (Integer)countAndBerg.getFirst();
        if (count > 0 && mutedSounds.add(sound) && Math.random() < 0.5) {
            int color = 50943;
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 5);
            SubTileBergamute berg = (SubTileBergamute)countAndBerg.getSecond();
            berg.method_10997().method_8406((class_2394)data, (double)berg.getEffectivePos().method_10263() + 0.3 + Math.random() * 0.5, (double)berg.getEffectivePos().method_10264() + 0.5 + Math.random() * 0.5, (double)berg.getEffectivePos().method_10260() + 0.3 + Math.random() * 0.5, 0.0, 0.0, 0.0);
        }
        return count;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 4.0);
    }
}

