/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.generating;

import java.util.ArrayList;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.tile.TileCell;

public class SubTileDandelifeon
extends TileEntityGeneratingFlower {
    private static final int RANGE = 12;
    private static final int SPEED = 10;
    private static final int MAX_MANA_GENERATIONS = 100;
    private static final int MANA_PER_GEN = 60;
    private static final int[][] ADJACENT_BLOCKS = new int[][]{{-1, -1}, {-1, 0}, {-1, 1}, {0, 1}, {1, 1}, {1, 0}, {1, -1}, {0, -1}};

    public SubTileDandelifeon(class_2338 pos, class_2680 state) {
        super(ModSubtiles.DANDELIFEON, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (!this.method_10997().field_9236 && this.ticksExisted % 10 == 0 && this.method_10997().method_8479(this.method_11016())) {
            this.runSimulation();
        }
    }

    private void runSimulation() {
        int[][] table = this.getCellTable();
        ArrayList<int[]> changes = new ArrayList<int[]>();
        boolean wipe = false;
        for (int i = 0; i < table.length; ++i) {
            for (int j = 0; j < table[0].length; ++j) {
                int gen = table[i][j];
                int adj = this.getAdjCells(table, i, j);
                int newVal = gen;
                if (adj < 2 || adj > 3) {
                    newVal = -1;
                } else if (adj == 3 && gen == -1) {
                    newVal = this.getSpawnCellGeneration(table, i, j);
                } else if (gen > -1) {
                    newVal = gen + 1;
                }
                int xdist = Math.abs(i - 12);
                int zdist = Math.abs(j - 12);
                int allowDist = 1;
                if (xdist <= allowDist && zdist <= allowDist && newVal > -1) {
                    gen = newVal;
                    int n = newVal = gen == 1 ? -1 : -2;
                }
                if (newVal == gen) continue;
                changes.add(new int[]{i, j, newVal, gen});
                if (newVal != -2) continue;
                wipe = true;
            }
        }
        class_2338 pos = this.getEffectivePos();
        for (int[] change : changes) {
            class_2338 pos_ = pos.method_10069(-12 + change[0], 0, -12 + change[1]);
            int val = change[2];
            if (val != -2 && wipe) {
                val = -1;
            }
            int old = change[3];
            this.setBlockForGeneration(pos_, val, old);
        }
    }

    private int[][] getCellTable() {
        int diam = 25;
        int[][] table = new int[diam][diam];
        class_2338 pos = this.getEffectivePos();
        for (int i = 0; i < diam; ++i) {
            for (int j = 0; j < diam; ++j) {
                class_2338 pos_ = pos.method_10069(-12 + i, 0, -12 + j);
                table[i][j] = this.getCellGeneration(pos_);
            }
        }
        return table;
    }

    private int getCellGeneration(class_2338 pos) {
        class_2586 tile = this.method_10997().method_8321(pos);
        if (tile instanceof TileCell) {
            return ((TileCell)tile).isSameFlower(this) ? ((TileCell)tile).getGeneration() : 0;
        }
        return -1;
    }

    private int getAdjCells(int[][] table, int x, int z) {
        int count = 0;
        for (int[] shift : ADJACENT_BLOCKS) {
            int gen;
            int xp = x + shift[0];
            int zp = z + shift[1];
            if (this.isOffBounds(table, xp, zp) || (gen = table[xp][zp]) < 0) continue;
            ++count;
        }
        return count;
    }

    private int getSpawnCellGeneration(int[][] table, int x, int z) {
        int max = -1;
        for (int[] shift : ADJACENT_BLOCKS) {
            int gen;
            int xp = x + shift[0];
            int zp = z + shift[1];
            if (this.isOffBounds(table, xp, zp) || (gen = table[xp][zp]) <= max) continue;
            max = gen;
        }
        return max == -1 ? -1 : max + 1;
    }

    boolean isOffBounds(int[][] table, int x, int z) {
        return x < 0 || z < 0 || x >= table.length || z >= table[0].length;
    }

    void setBlockForGeneration(class_2338 pos, int gen, int prevGen) {
        class_1937 world = this.method_10997();
        class_2680 stateAt = world.method_8320(pos);
        class_2586 tile = world.method_8321(pos);
        if (gen == -2) {
            int val = Math.min(100, prevGen) * 60;
            this.addMana(val);
        } else if (stateAt.method_27852(ModBlocks.cellBlock)) {
            if (gen < 0) {
                world.method_8650(pos, false);
            } else {
                ((TileCell)tile).setGeneration(this, gen);
            }
        } else if (gen >= 0 && stateAt.method_26215()) {
            world.method_8501(pos, ModBlocks.cellBlock.method_9564());
            tile = world.method_8321(pos);
            ((TileCell)tile).setGeneration(this, gen);
        }
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 12);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 1);
    }

    @Override
    public int getMaxMana() {
        return 50000;
    }

    @Override
    public int getColor() {
        return 10226302;
    }
}

