/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3902;
import vazkii.botania.api.block.IAvatarTile;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileSimpleInventory;

public class TileAvatar
extends TileSimpleInventory
implements IAvatarTile {
    private static final int MAX_MANA = 6400;
    private static final String TAG_ENABLED = "enabled";
    private static final String TAG_TICKS_ELAPSED = "ticksElapsed";
    private static final String TAG_MANA = "mana";
    private static final String TAG_COOLDOWNS = "boostCooldowns";
    private boolean enabled;
    private int ticksElapsed;
    private int mana;
    private final Map<UUID, Integer> boostCooldowns = new HashMap<UUID, Integer>();

    public TileAvatar(class_2338 pos, class_2680 state) {
        super(ModTiles.AVATAR, pos, state);
    }

    public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, TileAvatar self) {
        IAvatarWieldable wieldable;
        self.enabled = !level.method_8479(worldPosition);
        class_1799 stack = self.getItemHandler().method_5438(0);
        if (!stack.method_7960() && (wieldable = (IAvatarWieldable)IAvatarWieldable.API.find(stack, (Object)class_3902.field_17274)) != null) {
            wieldable.onAvatarUpdate(self);
        }
        if (self.enabled) {
            ++self.ticksElapsed;
        }
    }

    @Override
    public void writePacketNBT(class_2487 tag) {
        super.writePacketNBT(tag);
        tag.method_10556(TAG_ENABLED, this.enabled);
        tag.method_10569(TAG_TICKS_ELAPSED, this.ticksElapsed);
        tag.method_10569(TAG_MANA, this.mana);
        class_2499 boostCooldowns = new class_2499();
        for (Map.Entry<UUID, Integer> e : this.boostCooldowns.entrySet()) {
            class_2487 cmp = new class_2487();
            cmp.method_25927("id", e.getKey());
            cmp.method_10569("cooldown", e.getValue().intValue());
            boostCooldowns.add((Object)cmp);
        }
        tag.method_10566(TAG_COOLDOWNS, (class_2520)boostCooldowns);
    }

    @Override
    public void readPacketNBT(class_2487 tag) {
        super.readPacketNBT(tag);
        this.enabled = tag.method_10577(TAG_ENABLED);
        this.ticksElapsed = tag.method_10550(TAG_TICKS_ELAPSED);
        this.mana = tag.method_10550(TAG_MANA);
        this.boostCooldowns.clear();
        class_2499 boostCooldowns = tag.method_10554(TAG_COOLDOWNS, 10);
        for (class_2520 nbt : boostCooldowns) {
            class_2487 cmp = (class_2487)nbt;
            UUID id = cmp.method_25926("id");
            int cooldown = cmp.method_10550("cooldown");
            this.boostCooldowns.put(id, cooldown);
        }
    }

    @Override
    protected class_1277 createItemHandler() {
        return new class_1277(1){

            public int method_5444() {
                return 1;
            }
        };
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public boolean isFull() {
        return this.mana >= 6400;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(19200, this.mana + mana);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.getItemHandler().method_5438(0).method_7960();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public class_1263 getInventory() {
        return this.getItemHandler();
    }

    @Override
    public class_2350 getAvatarFacing() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12481);
    }

    @Override
    public int getElapsedFunctionalTicks() {
        return this.ticksElapsed;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Map<UUID, Integer> getBoostCooldowns() {
        return this.boostCooldowns;
    }
}

