/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4587;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.brew.IBrewContainer;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.recipe.IBrewRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class TileBrewery
extends TileSimpleInventory
implements IManaReceiver,
IWandHUD {
    private static final String TAG_MANA = "mana";
    private static final int CRAFT_EFFECT_EVENT = 0;
    public IBrewRecipe recipe;
    private int mana = 0;
    private int manaLastTick = 0;
    public int signal = 0;

    public TileBrewery(class_2338 pos, class_2680 state) {
        super(ModTiles.BREWERY, pos, state);
    }

    public boolean addItem(@Nullable class_1657 player, class_1799 stack, @Nullable class_1268 hand) {
        if (this.recipe != null || stack.method_7960() || stack.method_7909() instanceof IBrewItem && ((IBrewItem)stack.method_7909()).getBrew(stack) != null && ((IBrewItem)stack.method_7909()).getBrew(stack) != ModBrews.fallbackBrew || this.getItemHandler().method_5438(0).method_7960() != stack.method_7909() instanceof IBrewContainer) {
            return false;
        }
        boolean did = false;
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (!this.getItemHandler().method_5438(i).method_7960()) continue;
            did = true;
            class_1799 stackToAdd = stack.method_7972();
            stackToAdd.method_7939(1);
            this.getItemHandler().method_5447(i, stackToAdd);
            if (player != null && player.method_31549().field_7477) break;
            stack.method_7934(1);
            if (!stack.method_7960() || player == null) break;
            player.method_6122(hand, class_1799.field_8037);
            break;
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            this.findRecipe();
        }
        return true;
    }

    private void findRecipe() {
        Optional maybeRecipe = this.field_11863.method_8433().method_8132(ModRecipeTypes.BREW_TYPE, this.getItemHandler(), this.field_11863);
        maybeRecipe.ifPresent(recipeBrew -> {
            this.recipe = recipeBrew;
            this.field_11863.method_8501(this.field_11867, (class_2680)ModBlocks.brewery.method_9564().method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(true)));
        });
    }

    public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, TileBrewery self) {
        if (self.mana > 0 && self.recipe == null) {
            self.findRecipe();
            if (self.recipe == null) {
                self.mana = 0;
            }
        }
        self.receiveMana(0);
        if (!level.field_9236 && self.recipe == null) {
            List items = level.method_18467(class_1542.class, new class_238((double)worldPosition.method_10263(), (double)worldPosition.method_10264(), (double)worldPosition.method_10260(), (double)(worldPosition.method_10263() + 1), (double)(worldPosition.method_10264() + 1), (double)(worldPosition.method_10260() + 1)));
            for (class_1542 item : items) {
                if (!item.method_5805() || item.method_6983().method_7960()) continue;
                class_1799 stack = item.method_6983();
                self.addItem(null, stack, null);
            }
        }
        if (self.recipe != null) {
            if (!self.recipe.method_8115(self.getItemHandler(), level)) {
                self.recipe = null;
                level.method_8501(worldPosition, ModBlocks.brewery.method_9564());
            }
            if (self.recipe != null) {
                if (self.mana != self.manaLastTick) {
                    int color = self.recipe.getBrew().getColor(self.getItemHandler().method_5438(0));
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    for (int i = 0; i < 5; ++i) {
                        WispParticleData data1 = WispParticleData.wisp(0.1f + (float)Math.random() * 0.05f, r, g, b);
                        level.method_8406((class_2394)data1, (double)worldPosition.method_10263() + 0.7 - Math.random() * 0.4, (double)worldPosition.method_10264() + 0.9 - Math.random() * 0.2, (double)worldPosition.method_10260() + 0.7 - Math.random() * 0.4, (double)(0.03f - (float)Math.random() * 0.06f), (double)(0.03f + (float)Math.random() * 0.015f), (double)(0.03f - (float)Math.random() * 0.06f));
                        for (int j = 0; j < 2; ++j) {
                            WispParticleData data = WispParticleData.wisp(0.1f + (float)Math.random() * 0.2f, 0.2f, 0.2f, 0.2f);
                            level.method_8406((class_2394)data, (double)worldPosition.method_10263() + 0.7 - Math.random() * 0.4, (double)worldPosition.method_10264() + 0.9 - Math.random() * 0.2, (double)worldPosition.method_10260() + 0.7 - Math.random() * 0.4, (double)(0.03f - (float)Math.random() * 0.06f), (double)(0.03f + (float)Math.random() * 0.015f), (double)(0.03f - (float)Math.random() * 0.06f));
                        }
                    }
                }
                if (self.mana >= self.getManaCost() && !level.field_9236) {
                    int mana = self.getManaCost();
                    self.receiveMana(-mana);
                    class_1799 output = self.recipe.getOutput(self.getItemHandler().method_5438(0));
                    class_1542 outputItem = new class_1542(level, (double)worldPosition.method_10263() + 0.5, (double)worldPosition.method_10264() + 1.5, (double)worldPosition.method_10260() + 0.5, output);
                    level.method_8649((class_1297)outputItem);
                    level.method_8427(worldPosition, ModBlocks.brewery, 0, self.recipe.getBrew().getColor(output));
                    for (int i = 0; i < self.inventorySize(); ++i) {
                        self.getItemHandler().method_5447(i, class_1799.field_8037);
                    }
                }
            }
        }
        int newSignal = 0;
        if (self.recipe != null) {
            ++newSignal;
        }
        if (newSignal != self.signal) {
            self.signal = newSignal;
            level.method_8455(worldPosition, state.method_26204());
        }
        self.manaLastTick = self.mana;
    }

    public boolean method_11004(int event, int param) {
        if (event == 0) {
            if (this.field_11863.field_9236) {
                for (int i = 0; i < 25; ++i) {
                    float r = (float)(param >> 16 & 0xFF) / 255.0f;
                    float g = (float)(param >> 8 & 0xFF) / 255.0f;
                    float b = (float)(param & 0xFF) / 255.0f;
                    SparkleParticleData data1 = SparkleParticleData.sparkle((float)Math.random() * 2.0f + 0.5f, r, g, b, 10);
                    this.field_11863.method_8406((class_2394)data1, (double)this.field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.field_11867.method_10264() + 1), (double)this.field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    for (int j = 0; j < 2; ++j) {
                        WispParticleData data = WispParticleData.wisp(0.1f + (float)Math.random() * 0.2f, 0.2f, 0.2f, 0.2f);
                        this.field_11863.method_8406((class_2394)data, (double)this.field_11867.method_10263() + 0.7 - Math.random() * 0.4, (double)this.field_11867.method_10264() + 0.9 - Math.random() * 0.2, (double)this.field_11867.method_10260() + 0.7 - Math.random() * 0.4, (double)(0.05f - (float)Math.random() * 0.1f), (double)(0.05f + (float)Math.random() * 0.03f), (double)(0.05f - (float)Math.random() * 0.1f));
                    }
                }
                this.field_11863.method_8486((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), ModSounds.potionCreate, class_3419.field_15245, 1.0f, 1.5f + (float)Math.random() * 0.25f, false);
            }
            return true;
        }
        return super.method_11004(event, param);
    }

    public int getManaCost() {
        class_1792 class_17922;
        class_1799 stack = this.getItemHandler().method_5438(0);
        if (this.recipe == null || stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof IBrewContainer)) {
            return 0;
        }
        IBrewContainer container = (IBrewContainer)class_17922;
        return container.getManaCost(this.recipe.getBrew(), stack);
    }

    @Override
    public void writePacketNBT(class_2487 tag) {
        super.writePacketNBT(tag);
        tag.method_10569(TAG_MANA, this.mana);
    }

    @Override
    public void readPacketNBT(class_2487 tag) {
        super.readPacketNBT(tag);
        this.mana = tag.method_10550(TAG_MANA);
    }

    @Override
    protected class_1277 createItemHandler() {
        return new class_1277(7){

            public int method_5444() {
                return 1;
            }
        };
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.getManaCost();
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(this.mana + mana, this.getManaCost());
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderHUD(class_4587 ms, class_310 mc) {
        int manaToGet = this.getManaCost();
        if (manaToGet > 0) {
            int x = mc.method_22683().method_4486() / 2 + 20;
            int y = mc.method_22683().method_4502() / 2 - 8;
            if (this.recipe == null) {
                return;
            }
            RenderHelper.renderProgressPie(ms, x, y, (float)this.mana / (float)manaToGet, this.recipe.getOutput(this.getItemHandler().method_5438(0)));
        }
    }
}

