/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import javax.annotation.Nullable;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachmentBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;

public class TilePlatform
extends TileMod
implements RenderAttachmentBlockEntity,
IWandable {
    private static final String TAG_CAMO = "camo";
    @Nullable
    private class_2680 camoState;

    public TilePlatform(class_2338 pos, class_2680 state) {
        super(ModTiles.PLATFORM, pos, state);
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        if (player != null) {
            BlockPlatform.Variant variant = this.getVariant();
            if (variant.indestructible && !player.method_7337()) {
                return false;
            }
            if (this.getCamoState() == null || player.method_5715()) {
                this.swapSelfAndPass(this, true, variant);
            } else {
                this.swapSurroudings(this, false, variant);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public class_2680 getCamoState() {
        return this.camoState;
    }

    public void setCamoState(@Nullable class_2680 state) {
        this.camoState = state;
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
            if (!this.field_11863.field_9236) {
                this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
            }
        }
    }

    private BlockPlatform.Variant getVariant() {
        return ((BlockPlatform)this.method_11010().method_26204()).getVariant();
    }

    private void swapSelfAndPass(TilePlatform tile, boolean empty, BlockPlatform.Variant variant) {
        this.swap(tile, empty);
        this.swapSurroudings(tile, empty, variant);
    }

    private void swapSurroudings(TilePlatform tile, boolean empty, BlockPlatform.Variant variant) {
        for (class_2350 dir : class_2350.values()) {
            class_2338 pos = tile.method_11016().method_10093(dir);
            class_2586 tileAt = this.field_11863.method_8321(pos);
            if (!(tileAt instanceof TilePlatform)) continue;
            TilePlatform platform = (TilePlatform)tileAt;
            if (tile.getVariant() != platform.getVariant() || empty != (platform.getCamoState() != null)) continue;
            this.swapSelfAndPass(platform, empty, variant);
        }
    }

    private void swap(TilePlatform tile, boolean empty) {
        tile.setCamoState(empty ? null : this.getCamoState());
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        if (this.getCamoState() != null) {
            cmp.method_10566(TAG_CAMO, (class_2520)class_2512.method_10686((class_2680)this.getCamoState()));
        }
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        class_2680 state = class_2512.method_10681((class_2487)cmp.method_10562(TAG_CAMO));
        if (state.method_26215()) {
            state = null;
        }
        this.setCamoState(state);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 0);
        }
    }

    public Object getRenderAttachmentData() {
        return new PlatformData(this.method_11016().method_10062(), this.camoState);
    }

    public record PlatformData(class_2338 pos, @Nullable class_2680 state) {
    }
}

