/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.corporea;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.IWandable;
import vazkii.botania.api.corporea.CorporeaHelper;
import vazkii.botania.api.corporea.ICorporeaRequestMatcher;
import vazkii.botania.api.corporea.ICorporeaRequestor;
import vazkii.botania.api.corporea.ICorporeaSpark;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.corporea.TileCorporeaBase;

public class TileCorporeaCrystalCube
extends TileCorporeaBase
implements ICorporeaRequestor,
IWandable {
    private static final String TAG_REQUEST_TARGET = "requestTarget";
    private static final String TAG_ITEM_COUNT = "itemCount";
    private static final String TAG_LOCK = "lock";
    private class_1799 requestTarget = class_1799.field_8037;
    private int itemCount = 0;
    private int ticks = 0;
    private int compValue = 0;
    public boolean locked = false;

    public TileCorporeaCrystalCube(class_2338 pos, class_2680 state) {
        super(ModTiles.CORPOREA_CRYSTAL_CUBE, pos, state);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, TileCorporeaCrystalCube self) {
        ++self.ticks;
        if (self.ticks % 20 == 0) {
            self.updateCount();
        }
    }

    public void setRequestTarget(class_1799 stack) {
        if (!stack.method_7960() && !this.locked) {
            class_1799 copy = stack.method_7972();
            copy.method_7939(1);
            this.requestTarget = copy;
            this.updateCount();
            if (!this.field_11863.field_9236) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
        }
    }

    public class_1799 getRequestTarget() {
        return this.requestTarget;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void doRequest(boolean fullStack) {
        if (this.field_11863.field_9236) {
            return;
        }
        ICorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !this.requestTarget.method_7960()) {
            int count = fullStack ? this.requestTarget.method_7914() : 1;
            this.doCorporeaRequest(CorporeaHelper.instance().createMatcher(this.requestTarget, true), count, spark);
        }
    }

    private void updateCount() {
        if (this.field_11863.field_9236) {
            return;
        }
        int sum = 0;
        ICorporeaSpark spark = this.getSpark();
        if (spark != null && spark.getMaster() != null && !this.requestTarget.method_7960()) {
            List<class_1799> stacks = CorporeaHelper.instance().requestItem(CorporeaHelper.instance().createMatcher(this.requestTarget, true), -1, spark, false).getStacks();
            for (class_1799 stack : stacks) {
                sum += stack.method_7947();
            }
        }
        this.setCount(sum);
    }

    private void setCount(int count) {
        int oldCount = this.itemCount;
        this.itemCount = count;
        if (this.itemCount != oldCount) {
            int oldCompValue = this.compValue;
            this.compValue = CorporeaHelper.instance().signalStrengthForRequestSize(this.itemCount);
            if (this.compValue != oldCompValue && this.field_11863 != null) {
                this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
            }
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public void writePacketNBT(class_2487 tag) {
        super.writePacketNBT(tag);
        class_2487 cmp = new class_2487();
        if (!this.requestTarget.method_7960()) {
            cmp = this.requestTarget.method_7953(cmp);
        }
        tag.method_10566(TAG_REQUEST_TARGET, (class_2520)cmp);
        tag.method_10569(TAG_ITEM_COUNT, this.itemCount);
        tag.method_10556(TAG_LOCK, this.locked);
    }

    @Override
    public void readPacketNBT(class_2487 tag) {
        super.readPacketNBT(tag);
        class_2487 cmp = tag.method_10562(TAG_REQUEST_TARGET);
        this.requestTarget = class_1799.method_7915((class_2487)cmp);
        this.setCount(tag.method_10550(TAG_ITEM_COUNT));
        this.locked = tag.method_10577(TAG_LOCK);
    }

    public int getComparatorValue() {
        return this.compValue;
    }

    @Override
    public void doCorporeaRequest(ICorporeaRequestMatcher request, int count, ICorporeaSpark spark) {
        if (!this.requestTarget.method_7960()) {
            List<class_1799> stacks = CorporeaHelper.instance().requestItem(request, count, spark, true).getStacks();
            spark.onItemsRequested(stacks);
            boolean did = false;
            int sum = 0;
            for (class_1799 reqStack : stacks) {
                class_1542 item = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, reqStack);
                this.field_11863.method_8649((class_1297)item);
                if (!this.requestTarget.method_7962(reqStack)) continue;
                sum += reqStack.method_7947();
                did = true;
            }
            if (did) {
                this.setCount(this.getItemCount() - sum);
            }
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        if (player == null || player.method_5715()) {
            boolean bl = this.locked = !this.locked;
            if (!this.field_11863.field_9236) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
            }
            return true;
        }
        return false;
    }
}

