/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import vazkii.botania.common.Botania;
import vazkii.patchouli.api.PatchouliAPI;

public final class ConfigHandler {
    public static final Client CLIENT = new Client();
    public static final Common COMMON = new Common();
    public static Set<class_2960> blacklistedRannuncarpusItems;
    public static Set<String> blacklistedRannuncarpusModIds;

    private static void writeDefaultConfig(ConfigTree config, Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s2 = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)config, (OutputStream)s2, (ValueSerializer)serializer);
        }
        catch (FileAlreadyExistsException s2) {
        }
        catch (IOException e) {
            Botania.LOGGER.error("Error writing default config", (Throwable)e);
        }
    }

    private static void setupConfig(ConfigTree config, Path p, JanksonValueSerializer serializer) {
        ConfigHandler.writeDefaultConfig(config, p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)config, (InputStream)s, (ValueSerializer)serializer);
            ConfigHandler.onConfigLoad();
        }
        catch (ValueDeserializationException | IOException e) {
            Botania.LOGGER.error("Error loading config from {}", (Object)p, (Object)e);
        }
    }

    public static void setup() {
        try {
            Files.createDirectory(Paths.get("config", new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            Botania.LOGGER.warn("Failed to make config dir", (Throwable)e);
        }
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        ConfigTree common = COMMON.configure(ConfigTree.builder());
        ConfigHandler.setupConfig(common, Paths.get("config", "botania-common.json5"), serializer);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ConfigTree client = CLIENT.configure(ConfigTree.builder());
            ConfigHandler.setupConfig(client, Paths.get("config", "botania-client.json5"), serializer);
        }
    }

    private static void onConfigLoad() {
        blacklistedRannuncarpusItems = ((List)ConfigHandler.COMMON.rannuncarpusItemBlacklist.getValue()).stream().map(class_2960::new).collect(Collectors.toSet());
        blacklistedRannuncarpusModIds = new HashSet<String>((Collection)ConfigHandler.COMMON.rannuncarpusModBlacklist.getValue());
        PatchouliAPI.get().setConfigFlag("botania:relics", ((Boolean)ConfigHandler.COMMON.relicsEnabled.getValue()).booleanValue());
        PatchouliAPI.get().setConfigFlag("botania:enchanter", ((Boolean)ConfigHandler.COMMON.enchanterEnabled.getValue()).booleanValue());
        PatchouliAPI.get().setConfigFlag("botania:ender_hand_pickpocket", ((Boolean)ConfigHandler.COMMON.enderPickpocketEnabled.getValue()).booleanValue());
        Botania.configLoaded = true;
    }

    public static class Common {
        public final PropertyMirror<Boolean> blockBreakParticles = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> blockBreakParticlesTool = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> chargingAnimationEnabled = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> silentSpreaders = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Integer> spreaderTraceTime = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Boolean> enderPickpocketEnabled = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> enchanterEnabled = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> fluxfieldEnabled = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> relicsEnabled = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> invertMagnetRing = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Integer> harvestLevelWeight = PropertyMirror.create((ConfigType)ConfigTypes.NATURAL.withMinimum((Object)0).withMaximum((Object)4));
        public final PropertyMirror<Integer> harvestLevelBore = PropertyMirror.create((ConfigType)ConfigTypes.NATURAL.withMinimum((Object)0).withMaximum((Object)4));
        public final PropertyMirror<Boolean> gogSpawnWithLexicon = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Integer> gogIslandScaleMultiplier = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        public final PropertyMirror<Boolean> worldgenEnabled = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<List<String>> rannuncarpusItemBlacklist = PropertyMirror.create((ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING));
        public final PropertyMirror<List<String>> rannuncarpusModBlacklist = PropertyMirror.create((ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING));

        public ConfigTree configure(ConfigTreeBuilder builder) {
            builder.fork("blockBreakingParticles").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to remove the block breaking particles from the flowers and other items in the mod.").finishValue(arg_0 -> this.blockBreakParticles.mirror(arg_0)).beginValue("toolEnabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to remove the block breaking particles from the Terra Shatterer, as there can be a good amount in higher levels.").finishValue(arg_0 -> this.blockBreakParticlesTool.mirror(arg_0)).finishBranch().fork("manaSpreaders").beginValue("silent", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Set this to true to disable the mana spreader shooting sound").finishValue(arg_0 -> this.silentSpreaders.mirror(arg_0)).beginValue("traceTime", (ConfigType)ConfigTypes.NATURAL, (Object)400).withComment("How many ticks into the future will mana spreaders attempt to predict where mana bursts go? Setting this lower will improve spreader performance, but will cause them to not fire at targets that are too far away.").finishValue(arg_0 -> this.spreaderTraceTime.mirror(arg_0)).finishBranch().fork("harvestLevels").beginValue("weightLens", (ConfigType)ConfigTypes.NATURAL, (Object)2).withComment("The harvest level of the Mana Lens: Weight. 3 is diamond level. Defaults to 2 (iron level)").finishValue(arg_0 -> this.harvestLevelWeight.mirror(arg_0)).beginValue("boreLens", (ConfigType)ConfigTypes.NATURAL, (Object)3).withComment("The harvest level of the Mana Lens: Bore. 3 is diamond level. Defaults to 3").finishValue(arg_0 -> this.harvestLevelBore.mirror(arg_0)).finishBranch().beginValue("worldgen", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable mystical flower and mushroom worldgen. More fine-tuned customization should be done with datapacks.").finishValue(arg_0 -> this.worldgenEnabled.mirror(arg_0)).beginValue("chargeAnimation", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable the animation when an item is charging on top of a mana pool").finishValue(arg_0 -> this.chargingAnimationEnabled.mirror(arg_0)).beginValue("enderPickpocket", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set to false to disable the ability for the Hand of Ender to pickpocket other players' ender chests").finishValue(arg_0 -> this.enderPickpocketEnabled.mirror(arg_0)).beginValue("manaEnchanter", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable the Mana Enchanter. Since some people find it OP or something. This only disables the entry and creation. Old ones that are already in the world will stay.").finishValue(arg_0 -> this.enchanterEnabled.mirror(arg_0)).beginValue("relics", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable the Relic System. This only disables the entries, drops and achievements. Old ones that are already in the world will stay.").finishValue(arg_0 -> this.relicsEnabled.mirror(arg_0)).beginValue("invertMagnetRing", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Set this to true to invert the Ring of Magnetization's controls (from shift to stop to shift to work)").finishValue(arg_0 -> this.invertMagnetRing.mirror(arg_0)).beginValue("gardenOfGlass.spawnWithLexicon", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable spawning with a Lexica Botania in Garden of Glass worlds, if you are modifying the modpack's progression to not start with Botania.").finishValue(arg_0 -> this.gogSpawnWithLexicon.mirror(arg_0)).beginValue("gardenOfGlass.islandScaleMultiplier", (ConfigType)ConfigTypes.INTEGER.withMinimum((Object)1).withMaximum((Object)512), (Object)8).withComment("The multiplier for island distances for multiplayer Garden of Glass worlds.\nIslands are placed on a grid with 256 blocks between points, with the spawn island always being placed on 256, 256.\nBy default, the scale is 8, putting each island on points separated by 2048 blocks.\nValues below 4 (1024 block spacing) are not recommended due to Nether portal collisions.").finishValue(arg_0 -> this.gogIslandScaleMultiplier.mirror(arg_0)).beginValue("rannuncarpusItemBlackList", (ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING), Collections.emptyList()).withComment("List of item registry names that will be ignored by rannuncarpuses when placing blocks.").finishValue(arg_0 -> this.rannuncarpusItemBlacklist.mirror(arg_0)).beginValue("rannuncarpusModBlacklist", (ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING), Collections.singletonList("storagedrawers")).withComment("List of mod names for rannuncarpuses to ignore.\nIgnores Storage Drawers by default due to crashes with placing drawer blocks without player involvement.").finishValue(arg_0 -> this.rannuncarpusModBlacklist.mirror(arg_0));
            return builder.build();
        }
    }

    public static class Client {
        public final PropertyMirror<Boolean> lexiconRotatingItems = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> subtlePowerSystem = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> staticWandBeam = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> boundBlockWireframe = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> lexicon3dModel = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Double> flowerParticleFrequency = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE);
        public final PropertyMirror<Boolean> elfPortalParticlesEnabled = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> renderAccessories = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> enableSeasonalFeatures = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> enableFancySkybox = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> enableFancySkyboxInNormalWorlds = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Integer> manaBarHeight = PropertyMirror.create((ConfigType)ConfigTypes.NATURAL);
        public final PropertyMirror<Boolean> staticFloaters = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> debugInfo = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> referencesEnabled = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        public final PropertyMirror<Boolean> splashesEnabled = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);

        public ConfigTree configure(ConfigTreeBuilder builder) {
            builder.fork("rendering").beginValue("boundBlockWireframe", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable the wireframe when looking a block bound to something (spreaders, flowers, etc).").finishValue(arg_0 -> this.boundBlockWireframe.mirror(arg_0)).beginValue("accessories", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable rendering of accessories in the player.").finishValue(arg_0 -> this.renderAccessories.mirror(arg_0)).beginValue("manaBarHeight", (ConfigType)ConfigTypes.NATURAL, (Object)29).withComment("The height of the mana display bar in above the XP bar. You can change this if you have a mod that changes where the XP bar is.").finishValue(arg_0 -> this.manaBarHeight.mirror(arg_0)).beginValue("staticFloaters", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Set this to true if you use lots of floating flowers and are experiencing rendering lag. Will disable the floating flowers' animations and render them statically for a major performance boost. Hit F3+A in-world after toggling this.").finishValue(arg_0 -> this.staticFloaters.mirror(arg_0)).finishBranch().fork("fancySkybox").beginValue("enabled", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable the fancy skybox in Garden of Glass").finishValue(arg_0 -> this.enableFancySkybox.mirror(arg_0)).beginValue("normalWorlds", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Set this to true to enable the fancy skybox in non Garden of Glass worlds. (Does not require Garden of Glass loaded to use, needs 'fancySkybox.enabled' to be true as well)").finishValue(arg_0 -> this.enableFancySkyboxInNormalWorlds.mirror(arg_0)).finishBranch().fork("lexicon").beginValue("rotatingItems", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable the rotating items in the petal and rune entries in the Lexica Botania.").finishValue(arg_0 -> this.lexiconRotatingItems.mirror(arg_0)).beginValue("render_3d", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable the animated 3D render for the Lexica Botania.").finishValue(arg_0 -> this.lexicon3dModel.mirror(arg_0)).finishBranch().fork("particles").beginValue("powerSystem", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Set this to true to set the power system's particles to be a lot more subtle. Good for low-end systems, if the particles are causing lag.").finishValue(arg_0 -> this.subtlePowerSystem.mirror(arg_0)).beginValue("staticWandBeam", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Set this to true to use a static wand beam that shows every single position of the burst, similar to the way it used to work on old Botania versions. Warning: Disabled by default because it may be laggy.").finishValue(arg_0 -> this.staticWandBeam.mirror(arg_0)).beginValue("flowerFrequency", (ConfigType)ConfigTypes.DOUBLE, (Object)0.75).withComment("The frequency in which particles spawn from normal (worldgen) mystical flowers").finishValue(arg_0 -> this.flowerParticleFrequency.mirror(arg_0)).beginValue("elvenPortal", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable the particles in the elven portal.").finishValue(arg_0 -> this.elfPortalParticlesEnabled.mirror(arg_0)).finishBranch().beginValue("seasonalFeatures", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable seasonal features, such as halloween and christmas.").finishValue(arg_0 -> this.enableSeasonalFeatures.mirror(arg_0)).beginValue("debugInfo", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set to false to disable Botania's messages in the F3 debug screen").finishValue(arg_0 -> this.debugInfo.mirror(arg_0)).beginValue("references", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable the references in the flower tooltips. (You monster D:)").finishValue(arg_0 -> this.referencesEnabled.mirror(arg_0)).beginValue("splashes", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Set this to false to disable Botania's splashes in the main menu.").finishValue(arg_0 -> this.splashesEnabled.mirror(arg_0));
            return builder.build();
        }
    }
}

