/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import vazkii.botania.api.internal.IManaNetwork;
import vazkii.botania.api.mana.ManaNetworkCallback;
import vazkii.botania.common.core.helper.MathHelper;

public final class ManaNetworkHandler
implements IManaNetwork {
    public static final ManaNetworkHandler instance = new ManaNetworkHandler();
    private final WeakHashMap<class_1937, Set<class_2586>> manaPools = new WeakHashMap();
    private final WeakHashMap<class_1937, Set<class_2586>> manaCollectors = new WeakHashMap();

    public void onNetworkEvent(class_2586 be, ManaNetworkCallback.ManaBlockType type, ManaNetworkCallback.Action action) {
        WeakHashMap<class_1937, Set<class_2586>> map;
        WeakHashMap<class_1937, Set<class_2586>> weakHashMap = map = type == ManaNetworkCallback.ManaBlockType.COLLECTOR ? this.manaCollectors : this.manaPools;
        if (action == ManaNetworkCallback.Action.ADD) {
            this.add(map, be);
        } else {
            this.remove(map, be);
        }
    }

    @Override
    public void clear() {
        this.manaPools.clear();
        this.manaCollectors.clear();
    }

    @Override
    public class_2586 getClosestPool(class_2338 pos, class_1937 world, int limit) {
        if (this.manaPools.containsKey(world)) {
            return this.getClosest(this.manaPools.get(world), pos, limit);
        }
        return null;
    }

    @Override
    public class_2586 getClosestCollector(class_2338 pos, class_1937 world, int limit) {
        if (this.manaCollectors.containsKey(world)) {
            return this.getClosest(this.manaCollectors.get(world), pos, limit);
        }
        return null;
    }

    public boolean isCollectorIn(class_2586 tile) {
        return this.isIn(tile, this.manaCollectors);
    }

    public boolean isPoolIn(class_2586 tile) {
        return this.isIn(tile, this.manaPools);
    }

    private boolean isIn(class_2586 tile, Map<class_1937, Set<class_2586>> map) {
        Set<class_2586> set = map.get(tile.method_10997());
        return set != null && set.contains(tile);
    }

    @Nullable
    private class_2586 getClosest(Set<class_2586> tiles, class_2338 pos, int limit) {
        long minDist = Long.MAX_VALUE;
        long limitSquared = (long)limit * (long)limit;
        class_2586 closest = null;
        for (class_2586 te : tiles) {
            long distance;
            if (te.method_11015() || (distance = MathHelper.distSqr((class_2382)te.method_11016(), (class_2382)pos)) > limitSquared || distance >= minDist) continue;
            minDist = distance;
            closest = te;
        }
        return closest;
    }

    private void remove(Map<class_1937, Set<class_2586>> map, class_2586 tile) {
        class_1937 world = tile.method_10997();
        if (!map.containsKey(world)) {
            return;
        }
        map.get(world).remove(tile);
    }

    private void add(Map<class_1937, Set<class_2586>> map, class_2586 tile) {
        class_1937 world = tile.method_10997();
        map.computeIfAbsent(world, k -> new HashSet()).add(tile);
    }

    @Override
    public Set<class_2586> getAllCollectorsInWorld(class_1937 world) {
        return this.getAllInWorld(this.manaCollectors, world);
    }

    @Override
    public Set<class_2586> getAllPoolsInWorld(class_1937 world) {
        return this.getAllInWorld(this.manaPools, world);
    }

    private Set<class_2586> getAllInWorld(Map<class_1937, Set<class_2586>> map, class_1937 world) {
        Set<class_2586> ret = map.get(world);
        if (ret == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(ret);
    }
}

