/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import vazkii.botania.api.recipe.IElvenTradeRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class RecipeElvenTrade
implements IElvenTradeRecipe {
    private final class_2960 id;
    private final ImmutableList<class_1799> outputs;
    private final class_2371<class_1856> inputs;

    public RecipeElvenTrade(class_2960 id, class_1799[] outputs, class_1856 ... inputs) {
        this.id = id;
        this.outputs = ImmutableList.copyOf((Object[])outputs);
        this.inputs = class_2371.method_10211();
        this.inputs.addAll(Arrays.asList(inputs));
    }

    @Override
    public Optional<List<class_1799>> match(List<class_1799> stacks) {
        ArrayList<class_1856> inputsMissing = new ArrayList<class_1856>((Collection<class_1856>)this.inputs);
        ArrayList<class_1799> stacksToRemove = new ArrayList<class_1799>();
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            if (inputsMissing.isEmpty()) break;
            int stackIndex = -1;
            for (int i = 0; i < inputsMissing.size(); ++i) {
                class_1856 ingr = (class_1856)inputsMissing.get(i);
                if (!ingr.method_8093(stack)) continue;
                if (!stacksToRemove.contains(stack)) {
                    stacksToRemove.add(stack);
                }
                stackIndex = i;
                break;
            }
            if (stackIndex == -1) continue;
            inputsMissing.remove(stackIndex);
        }
        return inputsMissing.isEmpty() ? Optional.of(stacksToRemove) : Optional.empty();
    }

    @Override
    public boolean containsItem(class_1799 stack) {
        for (class_1856 input : this.inputs) {
            if (!input.method_8093(stack)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public class_1865<?> method_8119() {
        return ModRecipeTypes.ELVEN_TRADE_SERIALIZER;
    }

    @Override
    @Nonnull
    public class_2371<class_1856> method_8117() {
        return this.inputs;
    }

    @Nonnull
    public class_1799 method_17447() {
        return new class_1799((class_1935)ModBlocks.alfPortal);
    }

    @Nonnull
    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public List<class_1799> getOutputs() {
        return this.outputs;
    }

    @Override
    public List<class_1799> getOutputs(List<class_1799> inputs) {
        return this.getOutputs();
    }

    public static class Serializer
    implements class_1865<RecipeElvenTrade> {
        @Nonnull
        public RecipeElvenTrade fromJson(@Nonnull class_2960 id, @Nonnull JsonObject json) {
            JsonElement output = json.get("output");
            ArrayList<class_1799> outputStacks = new ArrayList<class_1799>();
            if (output.isJsonArray()) {
                for (JsonElement e : output.getAsJsonArray()) {
                    JsonObject o = class_3518.method_15295((JsonElement)e, (String)"output stack");
                    outputStacks.add(class_1869.method_35228((JsonObject)o));
                }
            } else {
                JsonObject o = class_3518.method_15295((JsonElement)output, (String)"output stack");
                outputStacks.add(class_1869.method_35228((JsonObject)o));
            }
            ArrayList<class_1856> inputs = new ArrayList<class_1856>();
            for (JsonElement e : class_3518.method_15261((JsonObject)json, (String)"ingredients")) {
                class_1856 ing = class_1856.method_8102((JsonElement)e);
                if (ing.method_8103()) continue;
                inputs.add(ing);
            }
            return new RecipeElvenTrade(id, outputStacks.toArray(new class_1799[0]), inputs.toArray(new class_1856[0]));
        }

        public RecipeElvenTrade fromNetwork(@Nonnull class_2960 id, class_2540 buf) {
            class_1856[] inputs = new class_1856[buf.method_10816()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = class_1856.method_8086((class_2540)buf);
            }
            class_1799[] outputs = new class_1799[buf.method_10816()];
            for (int i = 0; i < outputs.length; ++i) {
                outputs[i] = buf.method_10819();
            }
            return new RecipeElvenTrade(id, outputs, inputs);
        }

        public void toNetwork(class_2540 buf, RecipeElvenTrade recipe) {
            buf.method_10804(recipe.method_8117().size());
            for (class_1856 input : recipe.method_8117()) {
                input.method_8088(buf);
            }
            buf.method_10804(recipe.getOutputs().size());
            for (class_1799 output : recipe.getOutputs()) {
                buf.method_10793(output);
            }
        }
    }
}

