/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_156;
import net.minecraft.class_1613;
import net.minecraft.class_1639;
import net.minecraft.class_1640;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2580;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2718;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_39;
import net.minecraft.class_4081;
import net.minecraft.class_4587;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_768;
import vazkii.botania.client.core.handler.BossBarHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.advancements.DopplegangerNoArmorTrigger;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.VecHelper;
import vazkii.botania.common.entity.EntityMagicLandmine;
import vazkii.botania.common.entity.EntityMagicMissile;
import vazkii.botania.common.entity.EntityPixie;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketSpawnDoppleganger;
import vazkii.botania.mixin.AccessorMobEffect;

public class EntityDoppleganger
extends class_1308 {
    public static final float ARENA_RANGE = 12.0f;
    public static final int ARENA_HEIGHT = 5;
    private static final int SPAWN_TICKS = 160;
    public static final float MAX_HP = 320.0f;
    private static final int MOB_SPAWN_START_TICKS = 20;
    private static final int MOB_SPAWN_END_TICKS = 80;
    private static final int MOB_SPAWN_BASE_TICKS = 800;
    private static final int MOB_SPAWN_TICKS = 900;
    private static final int MOB_SPAWN_WAVES = 10;
    private static final int MOB_SPAWN_WAVE_TIME = 80;
    private static final int DAMAGE_CAP = 32;
    private static final String TAG_INVUL_TIME = "invulTime";
    private static final String TAG_AGGRO = "aggro";
    private static final String TAG_SOURCE_X = "sourceX";
    private static final String TAG_SOURCE_Y = "sourceY";
    private static final String TAG_SOURCE_Z = "sourcesZ";
    private static final String TAG_MOB_SPAWN_TICKS = "mobSpawnTicks";
    private static final String TAG_HARD_MODE = "hardMode";
    private static final String TAG_PLAYER_COUNT = "playerCount";
    private static final class_3494.class_5123<class_2248> BLACKLIST = ModTags.Blocks.GAIA_BREAK_BLACKLIST;
    private static final class_2940<Integer> INVUL_TIME = class_2945.method_12791(EntityDoppleganger.class, (class_2941)class_2943.field_13327);
    private static final List<class_2338> PYLON_LOCATIONS = ImmutableList.of((Object)new class_2338(4, 1, 4), (Object)new class_2338(4, 1, -4), (Object)new class_2338(-4, 1, 4), (Object)new class_2338(-4, 1, -4));
    private static final List<class_2960> CHEATY_BLOCKS = Arrays.asList(new class_2960("openblocks", "beartrap"), new class_2960("thaumictinkerer", "magnet"));
    private boolean spawnLandmines = false;
    private boolean spawnPixies = false;
    private boolean anyWithArmor = false;
    private boolean aggro = false;
    private int tpDelay = 0;
    private int mobSpawnTicks = 0;
    private int playerCount = 0;
    private boolean hardMode = false;
    private class_2338 source = class_2338.field_10980;
    private final List<UUID> playersWhoAttacked = new ArrayList<UUID>();
    private final class_3213 bossInfo = (class_3213)new class_3213(ModEntities.DOPPLEGANGER.method_5897(), class_1259.class_1260.field_5788, class_1259.class_1261.field_5795).method_5411(true);
    private UUID bossInfoUUID = this.bossInfo.method_5407();
    public class_1657 trueKiller = null;
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*]|ComputerCraft)$");

    public EntityDoppleganger(class_1299<EntityDoppleganger> type, class_1937 world) {
        super(type, world);
        this.field_6194 = 825;
        if (world.field_9236) {
            Botania.proxy.addBoss(this);
        }
    }

    public static boolean spawn(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos, boolean hard) {
        if (!(world.method_8321(pos) instanceof class_2580) || !EntityDoppleganger.isTruePlayer((class_1297)player) || EntityDoppleganger.countGaiaGuardiansAround(world, pos) > 0) {
            return false;
        }
        if (world.method_8407() == class_1267.field_5801) {
            if (!world.field_9236) {
                player.method_9203((class_2561)new class_2588("botaniamisc.peacefulNoob").method_27692(class_124.field_1061), class_156.field_25140);
            }
            return false;
        }
        List<class_2338> invalidPylonBlocks = EntityDoppleganger.checkPylons(world, pos);
        if (!invalidPylonBlocks.isEmpty()) {
            if (world.field_9236) {
                EntityDoppleganger.warnInvalidBlocks(world, invalidPylonBlocks);
            } else {
                player.method_9203((class_2561)new class_2588("botaniamisc.needsCatalysts").method_27692(class_124.field_1061), class_156.field_25140);
            }
            return false;
        }
        List<class_2338> invalidArenaBlocks = EntityDoppleganger.checkArena(world, pos);
        if (!invalidArenaBlocks.isEmpty()) {
            if (world.field_9236) {
                EntityDoppleganger.warnInvalidBlocks(world, invalidArenaBlocks);
            } else {
                PacketBotaniaEffect.send(player, PacketBotaniaEffect.EffectType.ARENA_INDICATOR, pos.method_10263(), pos.method_10264(), pos.method_10260(), new int[0]);
                player.method_9203((class_2561)new class_2588("botaniamisc.badArena").method_27692(class_124.field_1061), class_156.field_25140);
            }
            return false;
        }
        if (!world.field_9236) {
            int playerCount;
            stack.method_7934(1);
            EntityDoppleganger e = (EntityDoppleganger)ModEntities.DOPPLEGANGER.method_5883(world);
            e.method_5814((double)pos.method_10263() + 0.5, pos.method_10264() + 3, (double)pos.method_10260() + 0.5);
            e.setInvulTime(160);
            e.method_6033(1.0f);
            e.source = pos;
            e.mobSpawnTicks = 900;
            e.hardMode = hard;
            e.playerCount = playerCount = e.getPlayersAround().size();
            float healthMultiplier = 1.0f;
            if (playerCount > 1) {
                healthMultiplier += (float)playerCount * 0.25f;
            }
            e.method_5996(class_5134.field_23716).method_6192((double)(320.0f * healthMultiplier));
            if (hard) {
                e.method_5996(class_5134.field_23724).method_6192(15.0);
            }
            e.method_5783(ModSounds.gaiaSummon, 1.0f, 1.0f);
            e.method_5943((class_5425)world, world.method_8404(e.method_24515()), class_3730.field_16467, null, null);
            world.method_8649((class_1297)e);
        }
        return true;
    }

    private static List<class_2338> checkPylons(class_1937 world, class_2338 beaconPos) {
        ArrayList<class_2338> invalidPylonBlocks = new ArrayList<class_2338>();
        for (class_2338 coords : PYLON_LOCATIONS) {
            class_2338 pos_ = beaconPos.method_10081((class_2382)coords);
            class_2680 state = world.method_8320(pos_);
            if (state.method_27852(ModBlocks.gaiaPylon)) continue;
            invalidPylonBlocks.add(pos_);
        }
        return invalidPylonBlocks;
    }

    private static List<class_2338> checkArena(class_1937 world, class_2338 beaconPos) {
        ArrayList<class_2338> trippedPositions = new ArrayList<class_2338>();
        int range = (int)Math.ceil(12.0);
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) == 4 && Math.abs(z) == 4 || MathHelper.pointDistancePlane(x, z, 0.0, 0.0) > 12.0f) continue;
                boolean hasFloor = false;
                for (int y = -2; y <= 5; ++y) {
                    boolean isBlockHere;
                    if (x == 0 && y == 0 && z == 0) continue;
                    class_2338 pos = beaconPos.method_10069(x, y, z);
                    class_2680 state = world.method_8320(pos);
                    boolean allowBlockHere = y < 0;
                    boolean bl = isBlockHere = !state.method_26220((class_1922)world, pos).method_1110();
                    if (allowBlockHere && isBlockHere) {
                        hasFloor = true;
                    }
                    if (y == 0 && !hasFloor) {
                        trippedPositions.add(pos.method_10074());
                    }
                    if (allowBlockHere || !isBlockHere || BLACKLIST.method_15141((Object)state.method_26204())) continue;
                    trippedPositions.add(pos);
                }
            }
        }
        return trippedPositions;
    }

    private static void warnInvalidBlocks(class_1937 world, Iterable<class_2338> invalidPositions) {
        WispParticleData data = WispParticleData.wisp(0.5f, 1.0f, 0.2f, 0.2f, 8.0f, false);
        for (class_2338 pos_ : invalidPositions) {
            world.method_8406((class_2394)data, (double)pos_.method_10263() + 0.5, (double)pos_.method_10264() + 0.5, (double)pos_.method_10260() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1361((class_1308)this, class_1657.class, 18.0f));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(INVUL_TIME, (Object)0);
    }

    public int getInvulTime() {
        return (Integer)this.field_6011.method_12789(INVUL_TIME);
    }

    public class_2338 getSource() {
        return this.source;
    }

    public void setInvulTime(int time) {
        this.field_6011.method_12778(INVUL_TIME, (Object)time);
    }

    public void method_5652(class_2487 cmp) {
        super.method_5652(cmp);
        cmp.method_10569(TAG_INVUL_TIME, this.getInvulTime());
        cmp.method_10556(TAG_AGGRO, this.aggro);
        cmp.method_10569(TAG_MOB_SPAWN_TICKS, this.mobSpawnTicks);
        cmp.method_10569(TAG_SOURCE_X, this.source.method_10263());
        cmp.method_10569(TAG_SOURCE_Y, this.source.method_10264());
        cmp.method_10569(TAG_SOURCE_Z, this.source.method_10260());
        cmp.method_10556(TAG_HARD_MODE, this.hardMode);
        cmp.method_10569(TAG_PLAYER_COUNT, this.playerCount);
    }

    public void method_5749(class_2487 cmp) {
        super.method_5749(cmp);
        this.setInvulTime(cmp.method_10550(TAG_INVUL_TIME));
        this.aggro = cmp.method_10577(TAG_AGGRO);
        this.mobSpawnTicks = cmp.method_10550(TAG_MOB_SPAWN_TICKS);
        int x = cmp.method_10550(TAG_SOURCE_X);
        int y = cmp.method_10550(TAG_SOURCE_Y);
        int z = cmp.method_10550(TAG_SOURCE_Z);
        this.source = new class_2338(x, y, z);
        this.hardMode = cmp.method_10577(TAG_HARD_MODE);
        this.playerCount = cmp.method_10545(TAG_PLAYER_COUNT) ? cmp.method_10550(TAG_PLAYER_COUNT) : 1;
        if (this.method_16914()) {
            this.bossInfo.method_5413(this.method_5476());
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossInfo.method_5413(this.method_5476());
    }

    public void method_6025(float amount) {
        if (this.getInvulTime() == 0) {
            super.method_6025(amount);
        }
    }

    public void method_5768() {
        this.method_6033(0.0f);
    }

    public boolean method_5643(@Nonnull class_1282 source, float amount) {
        class_1297 e = source.method_5529();
        if (e instanceof class_1657) {
            class_1657 player = (class_1657)e;
            if (EntityDoppleganger.isTruePlayer(e) && this.getInvulTime() == 0) {
                if (!this.playersWhoAttacked.contains(player.method_5667())) {
                    this.playersWhoAttacked.add(player.method_5667());
                }
                return super.method_5643(source, Math.min(32.0f, amount));
            }
        }
        return false;
    }

    public static boolean isTruePlayer(class_1297 e) {
        if (!(e instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)e;
        String name = player.method_5477().getString();
        return !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    protected void method_6074(@Nonnull class_1282 source, float amount) {
        super.method_6074(source, Math.min(32.0f, amount));
        class_1297 attacker = source.method_5526();
        if (attacker != null) {
            class_243 thisVector = VecHelper.fromEntityCenter((class_1297)this);
            class_243 playerVector = VecHelper.fromEntityCenter(attacker);
            class_243 motionVector = thisVector.method_1020(playerVector).method_1029().method_1021(0.75);
            if (this.method_6032() > 0.0f) {
                this.method_18800(-motionVector.field_1352, 0.5, -motionVector.field_1350);
                this.tpDelay = 4;
                this.spawnPixies = true;
            }
        }
        this.field_6008 = Math.max(this.field_6008, 20);
    }

    protected float method_6132(class_1282 source, float damage) {
        return super.method_6132(source, Math.min(32.0f, damage));
    }

    public void method_6078(@Nonnull class_1282 source) {
        super.method_6078(source);
        class_1309 lastAttacker = this.method_6124();
        if (!this.field_6002.field_9236) {
            for (UUID u : this.playersWhoAttacked) {
                class_1282 currSource;
                class_1657 player = this.field_6002.method_18470(u);
                if (!EntityDoppleganger.isTruePlayer((class_1297)player)) continue;
                class_1282 class_12822 = currSource = player == lastAttacker ? source : class_1282.method_5532((class_1657)player);
                if (player != lastAttacker) {
                    class_174.field_1192.method_8990((class_3222)player, (class_1297)this, currSource);
                }
                if (this.anyWithArmor) continue;
                DopplegangerNoArmorTrigger.INSTANCE.trigger((class_3222)player, this, currSource);
            }
            for (class_1657 player : this.getPlayersAround()) {
                if (player.method_6112(class_1294.field_5920) == null) continue;
                player.method_6016(class_1294.field_5920);
            }
            for (EntityPixie pixie : this.field_6002.method_8390(EntityPixie.class, EntityDoppleganger.getArenaBB(this.getSource()), p -> p.method_5805() && p.getPixieType() == 1)) {
                pixie.method_5990();
                pixie.method_31472();
            }
            for (EntityMagicLandmine landmine : this.field_6002.method_18467(EntityMagicLandmine.class, EntityDoppleganger.getArenaBB(this.getSource()))) {
                landmine.method_31472();
            }
        }
        this.method_5783(ModSounds.gaiaDeath, 1.0f, (1.0f + (this.field_6002.field_9229.nextFloat() - this.field_6002.field_9229.nextFloat()) * 0.2f) * 0.7f);
        this.field_6002.method_8406((class_2394)class_2398.field_11221, this.method_23317(), this.method_23318(), this.method_23321(), 1.0, 0.0, 0.0);
    }

    public boolean method_5974(double dist) {
        return false;
    }

    public class_2960 method_5991() {
        if (this.mobSpawnTicks > 0) {
            return class_39.field_844;
        }
        return ResourceLocationHelper.prefix(this.hardMode ? "gaia_guardian_2" : "gaia_guardian");
    }

    protected void method_16077(@Nonnull class_1282 source, boolean wasRecentlyHit) {
        if (wasRecentlyHit && EntityDoppleganger.isTruePlayer(source.method_5529())) {
            this.trueKiller = (class_1657)source.method_5529();
        }
        for (UUID u : this.playersWhoAttacked) {
            class_1657 player = this.field_6002.method_18470(u);
            if (!EntityDoppleganger.isTruePlayer((class_1297)player)) continue;
            class_1657 saveLastAttacker = this.field_6258;
            class_243 savePos = this.method_19538();
            this.field_6258 = player;
            this.method_5814(player.method_23317(), player.method_23318(), player.method_23321());
            super.method_16077(class_1282.method_5532((class_1657)player), wasRecentlyHit);
            this.method_5814(savePos.method_10216(), savePos.method_10214(), savePos.method_10215());
            this.field_6258 = saveLastAttacker;
        }
        this.trueKiller = null;
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (this.field_6002.field_9236) {
            Botania.proxy.removeBoss(this);
        }
        super.method_5650(reason);
    }

    public List<class_1657> getPlayersAround() {
        return this.field_6002.method_8390(class_1657.class, EntityDoppleganger.getArenaBB(this.source), player -> EntityDoppleganger.isTruePlayer((class_1297)player) && !player.method_7325());
    }

    private static int countGaiaGuardiansAround(class_1937 world, class_2338 source) {
        List l = world.method_18467(EntityDoppleganger.class, EntityDoppleganger.getArenaBB(source));
        return l.size();
    }

    @Nonnull
    private static class_238 getArenaBB(@Nonnull class_2338 source) {
        double range = 15.0;
        return new class_238((double)source.method_10263() + 0.5 - range, (double)source.method_10264() + 0.5 - range, (double)source.method_10260() + 0.5 - range, (double)source.method_10263() + 0.5 + range, (double)source.method_10264() + 0.5 + range, (double)source.method_10260() + 0.5 + range);
    }

    private void particles() {
        float rad;
        for (int i = 0; i < 360; i += 8) {
            float r = 0.6f;
            float g = 0.0f;
            float b = 0.2f;
            float m = 0.15f;
            float mv = 0.35f;
            rad = (float)i * (float)Math.PI / 180.0f;
            double x = (double)this.source.method_10263() + 0.5 - Math.cos(rad) * 12.0;
            double y = (double)this.source.method_10264() + 0.5;
            double z = (double)this.source.method_10260() + 0.5 - Math.sin(rad) * 12.0;
            WispParticleData data = WispParticleData.wisp(0.5f, r, g, b);
            this.field_6002.method_8406((class_2394)data, x, y, z, (double)((float)(Math.random() - 0.5) * m), (double)((float)(Math.random() - 0.5) * mv), (double)((float)(Math.random() - 0.5) * m));
        }
        if (this.getInvulTime() > 10) {
            class_243 pos = VecHelper.fromEntityCenter((class_1297)this).method_1023(0.0, 0.2, 0.0);
            for (class_2338 arr : PYLON_LOCATIONS) {
                class_243 pylonPos = new class_243((double)(this.source.method_10263() + arr.method_10263()), (double)(this.source.method_10264() + arr.method_10264()), (double)(this.source.method_10260() + arr.method_10260()));
                double worldTime = this.field_6012;
                rad = 0.75f + (float)Math.random() * 0.05f;
                double xp = pylonPos.field_1352 + 0.5 + Math.cos(worldTime /= 5.0) * (double)rad;
                double zp = pylonPos.field_1350 + 0.5 + Math.sin(worldTime) * (double)rad;
                class_243 partPos = new class_243(xp, pylonPos.field_1351, zp);
                class_243 mot = pos.method_1020(partPos).method_1021(0.04);
                float r = 0.7f + (float)Math.random() * 0.3f;
                float g = (float)Math.random() * 0.3f;
                float b = 0.7f + (float)Math.random() * 0.3f;
                WispParticleData data = WispParticleData.wisp(0.25f + (float)Math.random() * 0.1f, r, g, b, 1.0f);
                this.field_6002.method_8406((class_2394)data, partPos.field_1352, partPos.field_1351, partPos.field_1350, 0.0, (double)(-(-0.075f - (float)Math.random() * 0.015f)), 0.0);
                WispParticleData data1 = WispParticleData.wisp(0.4f, r, g, b);
                this.field_6002.method_8406((class_2394)data1, partPos.field_1352, partPos.field_1351, partPos.field_1350, (double)((float)mot.field_1352), (double)((float)mot.field_1351), (double)((float)mot.field_1350));
            }
        }
    }

    private void smashBlocksAround(int centerX, int centerY, int centerZ, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius + 1; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int x = centerX + dx;
                    int y = centerY + dy;
                    int z = centerZ + dz;
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = this.field_6002.method_8320(pos);
                    class_2248 block = state.method_26204();
                    if (state.method_26214((class_1922)this.field_6002, pos) == -1.0f) continue;
                    if (CHEATY_BLOCKS.contains(class_2378.field_11146.method_10221((Object)block))) {
                        this.field_6002.method_22352(pos, true);
                        continue;
                    }
                    if (BLACKLIST.method_15141((Object)block) || y < this.source.method_10264() || Math.abs(this.source.method_10263() - x) == 4 && Math.abs(this.source.method_10260() - z) == 4) continue;
                    this.field_6002.method_22352(pos, true);
                }
            }
        }
    }

    private void clearPotions(class_1657 player) {
        List<class_1291> potionsToRemove = player.method_6026().stream().filter(effect -> effect.method_5584() < 160 && effect.method_5591() && ((AccessorMobEffect)effect.method_5579()).getType() != class_4081.field_18272).map(class_1293::method_5579).distinct().collect(Collectors.toList());
        potionsToRemove.forEach(potion -> {
            player.method_6016(potion);
            ((class_3218)this.field_6002).method_14178().method_18751((class_1297)player, (class_2596)new class_2718(player.method_5628(), potion));
        });
    }

    private void keepInsideArena(class_1657 player) {
        if (MathHelper.pointDistanceSpace(player.method_23317(), player.method_23318(), player.method_23321(), (double)this.source.method_10263() + 0.5, (double)this.source.method_10264() + 0.5, (double)this.source.method_10260() + 0.5) >= 12.0f) {
            class_243 sourceVector = new class_243((double)this.source.method_10263() + 0.5, (double)this.source.method_10264() + 0.5, (double)this.source.method_10260() + 0.5);
            class_243 playerVector = VecHelper.fromEntityCenter((class_1297)player);
            class_243 motion = sourceVector.method_1020(playerVector).method_1029();
            player.method_18800(motion.field_1352, 0.2, motion.field_1350);
            player.field_6037 = true;
        }
    }

    private void spawnMobs(List<class_1657> players) {
        for (int pl = 0; pl < this.playerCount; ++pl) {
            for (int i = 0; i < 3 + this.field_6002.field_9229.nextInt(2); ++i) {
                class_1639 entity;
                switch (this.field_6002.field_9229.nextInt(3)) {
                    case 0: {
                        class_1639 class_16392;
                        if (this.field_6002.field_9229.nextInt(this.hardMode ? 3 : 12) == 0) {
                            class_16392 = (class_1640)class_1299.field_6145.method_5883(this.field_6002);
                            break;
                        }
                        class_16392 = (class_1642)class_1299.field_6051.method_5883(this.field_6002);
                        break;
                    }
                    case 1: {
                        class_1639 class_16392;
                        if (this.field_6002.field_9229.nextInt(8) == 0) {
                            class_16392 = (class_1639)class_1299.field_6076.method_5883(this.field_6002);
                            break;
                        }
                        class_16392 = (class_1613)class_1299.field_6137.method_5883(this.field_6002);
                        break;
                    }
                    case 2: {
                        if (!players.isEmpty()) {
                            for (int j = 0; j < 1 + this.field_6002.field_9229.nextInt(this.hardMode ? 8 : 5); ++j) {
                                EntityPixie pixie = new EntityPixie(this.field_6002);
                                pixie.setProps((class_1309)players.get(this.field_5974.nextInt(players.size())), (class_1309)this, 1, 8.0f);
                                pixie.method_5814(this.method_23317() + (double)(this.method_17681() / 2.0f), this.method_23318() + 2.0, this.method_23321() + (double)(this.method_17681() / 2.0f));
                                pixie.method_5943((class_5425)this.field_6002, this.field_6002.method_8404(pixie.method_24515()), class_3730.field_16471, null, null);
                                this.field_6002.method_8649((class_1297)pixie);
                            }
                        }
                        class_1639 class_16392 = null;
                        break;
                    }
                    default: {
                        class_1639 class_16392 = entity = null;
                    }
                }
                if (entity == null) continue;
                if (!entity.method_5753()) {
                    entity.method_6092(new class_1293(class_1294.field_5918, 600, 0));
                }
                float range = 6.0f;
                entity.method_5814(this.method_23317() + 0.5 + Math.random() * (double)range - (double)(range / 2.0f), this.method_23318() - 1.0, this.method_23321() + 0.5 + Math.random() * (double)range - (double)(range / 2.0f));
                entity.method_5943((class_5425)this.field_6002, this.field_6002.method_8404(entity.method_24515()), class_3730.field_16471, null, null);
                if (entity instanceof class_1639 && this.hardMode) {
                    entity.method_5673(class_1304.field_6173, new class_1799((class_1935)ModItems.elementiumSword));
                }
                this.field_6002.method_8649((class_1297)entity);
            }
        }
    }

    public void method_6007() {
        boolean spawnMissiles;
        super.method_6007();
        int invul = this.getInvulTime();
        if (this.field_6002.field_9236) {
            this.particles();
            class_1657 player = Botania.proxy.getClientPlayer();
            if (this.getPlayersAround().contains(player)) {
                player.method_31549().field_7479 &= player.method_31549().field_7477;
            }
            return;
        }
        this.bossInfo.method_5408(this.method_6032() / this.method_6063());
        if (this.method_5765()) {
            this.method_5848();
        }
        if (this.field_6002.method_8407() == class_1267.field_5801) {
            this.method_31472();
        }
        this.smashBlocksAround(class_3532.method_15357((double)this.method_23317()), class_3532.method_15357((double)this.method_23318()), class_3532.method_15357((double)this.method_23321()), 1);
        List<class_1657> players = this.getPlayersAround();
        if (players.isEmpty() && !this.field_6002.method_18456().isEmpty()) {
            this.method_31472();
        } else {
            for (class_1657 player : players) {
                for (class_1304 e : class_1304.values()) {
                    if (e.method_5925() != class_1304.class_1305.field_6178 || player.method_6118(e).method_7960()) continue;
                    this.anyWithArmor = true;
                    break;
                }
                if (player.method_6113()) {
                    player.method_18400();
                }
                this.clearPotions(player);
                this.keepInsideArena(player);
                player.method_31549().field_7479 &= player.method_31549().field_7477;
            }
        }
        if (!this.method_5805() || players.isEmpty()) {
            return;
        }
        boolean bl = spawnMissiles = this.hardMode && this.field_6012 % 15 < 4;
        if (invul > 0 && this.mobSpawnTicks == 900) {
            if (invul < 160 && invul > 80 && this.field_6002.field_9229.nextInt(160 - invul + 1) == 0) {
                for (int i = 0; i < 2; ++i) {
                    this.method_5990();
                }
            }
            this.method_6033(this.method_6032() + (this.method_6063() - 1.0f) / 160.0f);
            this.setInvulTime(invul - 1);
            this.method_18800(this.method_18798().method_10216(), 0.0, this.method_18798().method_10215());
        } else if (this.aggro) {
            boolean dying;
            boolean bl2 = dying = (double)(this.method_6032() / this.method_6063()) < 0.2;
            if (dying && this.mobSpawnTicks > 0) {
                this.method_18799(class_243.field_1353);
                int reverseTicks = 900 - this.mobSpawnTicks;
                if (reverseTicks < 20) {
                    this.method_18800(this.method_18798().method_10216(), 0.2, this.method_18798().method_10215());
                    this.setInvulTime(invul + 1);
                }
                if (reverseTicks > 40 && this.mobSpawnTicks > 80 && this.mobSpawnTicks % 80 == 0) {
                    this.spawnMobs(players);
                    if (this.hardMode && this.field_6012 % 3 < 2) {
                        for (i = 0; i < this.playerCount; ++i) {
                            this.spawnMissile();
                        }
                        spawnMissiles = false;
                    }
                }
                --this.mobSpawnTicks;
                this.tpDelay = 10;
            } else if (this.tpDelay > 0) {
                if (invul > 0) {
                    this.setInvulTime(invul - 1);
                }
                --this.tpDelay;
                if (this.tpDelay == 0 && this.method_6032() > 0.0f) {
                    this.teleportRandomly();
                    if (this.spawnLandmines) {
                        int count = dying && this.hardMode ? 7 : 6;
                        for (i = 0; i < count; ++i) {
                            int x = this.source.method_10263() - 10 + this.field_5974.nextInt(20);
                            int y = (int)players.get(this.field_5974.nextInt(players.size())).method_23318();
                            int z = this.source.method_10260() - 10 + this.field_5974.nextInt(20);
                            EntityMagicLandmine landmine = (EntityMagicLandmine)ModEntities.MAGIC_LANDMINE.method_5883(this.field_6002);
                            landmine.method_5814((double)x + 0.5, y, (double)z + 0.5);
                            landmine.summoner = this;
                            this.field_6002.method_8649((class_1297)landmine);
                        }
                    }
                    for (int pl = 0; pl < this.playerCount; ++pl) {
                        for (i = 0; i < (this.spawnPixies ? this.field_6002.field_9229.nextInt(this.hardMode ? 6 : 3) : 1); ++i) {
                            EntityPixie pixie = new EntityPixie(this.field_6002);
                            pixie.setProps((class_1309)players.get(this.field_5974.nextInt(players.size())), (class_1309)this, 1, 8.0f);
                            pixie.method_5814(this.method_23317() + (double)(this.method_17681() / 2.0f), this.method_23318() + 2.0, this.method_23321() + (double)(this.method_17681() / 2.0f));
                            pixie.method_5943((class_5425)this.field_6002, this.field_6002.method_8404(pixie.method_24515()), class_3730.field_16471, null, null);
                            this.field_6002.method_8649((class_1297)pixie);
                        }
                    }
                    this.tpDelay = this.hardMode ? (dying ? 35 : 45) : (dying ? 40 : 60);
                    this.spawnLandmines = true;
                    this.spawnPixies = false;
                }
            }
            if (spawnMissiles) {
                this.spawnMissile();
            }
        } else {
            this.tpDelay = 30;
            this.aggro = true;
        }
    }

    public boolean method_5822() {
        return false;
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossInfo.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
    }

    protected void method_6070() {
        if (this.getInvulTime() == 0) {
            super.method_6070();
        }
    }

    public boolean method_5810() {
        return super.method_5810() && this.getInvulTime() == 0;
    }

    private void spawnMissile() {
        EntityMagicMissile missile = new EntityMagicMissile((class_1309)this, true);
        missile.method_5814(this.method_23317() + (Math.random() - 0.05), this.method_23318() + 2.4 + (Math.random() - 0.05), this.method_23321() + (Math.random() - 0.05));
        if (missile.findTarget()) {
            this.method_5783(ModSounds.missile, 1.0f, 0.8f + (float)Math.random() * 0.2f);
            this.field_6002.method_8649((class_1297)missile);
        }
    }

    private void teleportRandomly() {
        class_243 newPosVec;
        class_2338 tentativeFloorPos;
        double newZ;
        double newX;
        double oldX = this.method_23317();
        double oldY = this.method_23318();
        double oldZ = this.method_23321();
        double newY = this.source.method_10264();
        int tries = 0;
        do {
            newX = (double)this.source.method_10263() + (this.field_5974.nextDouble() - 0.5) * 12.0;
            newZ = (double)this.source.method_10260() + (this.field_5974.nextDouble() - 0.5) * 12.0;
        } while (++tries < 50 && MathHelper.pointDistanceSpace(newX, newY, newZ, this.source.method_10263(), this.source.method_10264(), this.source.method_10260()) > 12.0f);
        if (tries == 50) {
            newX = (double)this.source.method_10263() + 0.5;
            newY = (double)this.source.method_10264() + 1.6;
            newZ = (double)this.source.method_10260() + 0.5;
        }
        if (this.field_6002.method_8320(tentativeFloorPos = new class_2338(newX, newY - 1.0, newZ)).method_26220((class_1922)this.field_6002, tentativeFloorPos).method_1110()) {
            newY -= 1.0;
        }
        this.method_5859(newX, newY, newZ);
        this.field_6002.method_8465(null, oldX, oldY, oldZ, ModSounds.gaiaTeleport, this.method_5634(), 1.0f, 1.0f);
        this.method_5783(ModSounds.gaiaTeleport, 1.0f, 1.0f);
        Random random = this.method_6051();
        int particleCount = 128;
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)(particleCount - 1);
            float vx = (random.nextFloat() - 0.5f) * 0.2f;
            float vy = (random.nextFloat() - 0.5f) * 0.2f;
            float vz = (random.nextFloat() - 0.5f) * 0.2f;
            double px = oldX + (newX - oldX) * progress + (random.nextDouble() - 0.5) * (double)this.method_17681() * 2.0;
            double py = oldY + (newY - oldY) * progress + random.nextDouble() * (double)this.method_17682();
            double pz = oldZ + (newZ - oldZ) * progress + (random.nextDouble() - 0.5) * (double)this.method_17681() * 2.0;
            this.field_6002.method_8406((class_2394)class_2398.field_11214, px, py, pz, (double)vx, (double)vy, (double)vz);
        }
        class_243 oldPosVec = new class_243(oldX, oldY + (double)(this.method_17682() / 2.0f), oldZ);
        if (oldPosVec.method_1025(newPosVec = new class_243(newX, newY + (double)(this.method_17682() / 2.0f), newZ)) > 1.0) {
            for (class_1657 player : this.getPlayersAround()) {
                boolean hit = player.method_5829().method_1014(0.25).method_992(oldPosVec, newPosVec).isPresent();
                if (!hit) continue;
                player.method_5643(class_1282.method_5511((class_1309)this), 6.0f);
            }
            int breakSteps = (int)oldPosVec.method_1022(newPosVec);
            if (breakSteps >= 2) {
                for (int i = 0; i < breakSteps; ++i) {
                    float progress = (float)i / (float)(breakSteps - 1);
                    int breakX = class_3532.method_15357((double)(oldX + (newX - oldX) * (double)progress));
                    int breakY = class_3532.method_15357((double)(oldY + (newY - oldY) * (double)progress));
                    int breakZ = class_3532.method_15357((double)(oldZ + (newZ - oldZ) * (double)progress));
                    this.smashBlocksAround(breakX, breakY, breakZ, 1);
                }
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_2960 getBossBarTexture() {
        return BossBarHandler.defaultBossBar;
    }

    @Environment(value=EnvType.CLIENT)
    public class_768 getBossBarTextureRect() {
        return new class_768(0, 0, 185, 15);
    }

    @Environment(value=EnvType.CLIENT)
    public class_768 getBossBarHPTextureRect() {
        class_768 barRect = this.getBossBarTextureRect();
        return new class_768(0, barRect.method_3322() + barRect.method_3320(), 181, 7);
    }

    @Environment(value=EnvType.CLIENT)
    public int bossBarRenderCallback(class_4587 ms, int x, int y) {
        ms.method_22903();
        int px = x + 160;
        int py = y + 12;
        class_310 mc = class_310.method_1551();
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        mc.method_1480().method_4010(stack, px, py);
        mc.field_1772.method_1720(ms, Integer.toString(this.playerCount), (float)(px + 15), (float)(py + 4), 0xFFFFFF);
        ms.method_22909();
        return 5;
    }

    public UUID getBossInfoUuid() {
        return this.bossInfoUUID;
    }

    @Environment(value=EnvType.CLIENT)
    public void readSpawnData(int playerCount, boolean hardMode, class_2338 source, UUID bossInfoUUID) {
        this.playerCount = playerCount;
        this.hardMode = hardMode;
        this.source = source;
        this.bossInfoUUID = bossInfoUUID;
        class_310.method_1551().method_1483().method_4873((class_1113)new DopplegangerMusic(this));
    }

    @Nonnull
    public class_2596<?> method_18002() {
        return PacketSpawnDoppleganger.make(this, this.playerCount, this.hardMode, this.source, this.bossInfoUUID);
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static class DopplegangerMusic
    extends class_1101 {
        private final EntityDoppleganger guardian;

        public DopplegangerMusic(EntityDoppleganger guardian) {
            super(guardian.hardMode ? ModSounds.gaiaMusic2 : ModSounds.gaiaMusic1, class_3419.field_15247);
            this.guardian = guardian;
            this.field_5439 = guardian.getSource().method_10263();
            this.field_5450 = guardian.getSource().method_10264();
            this.field_5449 = guardian.getSource().method_10260();
        }

        public void method_16896() {
            if (!this.guardian.method_5805()) {
                this.method_24876();
            }
        }
    }
}

